<?php

/*
 * Plugin Name: WooPricely - WooCommerce Dynamic Pricing & Discounts
 * Plugin URI: https://codecanyon.net/item/woopricely-dynamic-pricing-fees-discounts/23844181?ref=zendcrew
 * Description: A multi-purpose pricing and discount toolkit for your WooCommerce store.
 * Version: 1.3.8
 * Author: zendcrew
 * Author URI: https://codecanyon.net/user/zendcrew?ref=zendcrew
 * Tags: discounts, pricing, dynamic discounts, dynamic pricing, ecommerce, woocommerce, woocommerce prices, woocommerce bulk pricing, woocommerce discounts, woocommerce dynamic discounts, woocommerce dynamic pricing, woocommerce pricing, woocommerce bulk discounts, woocommerce wholesale pricing
 * Text Domain: zcpri-woopricely
 * Domain Path: /languages/
 * Requires at least: 5.8
 * Tested up to: 6.0.2
 * Requires PHP: 5.6
 * 
 * WC requires at least: 5.6
 * WC tested up to: 6.8.2
 */

if ( !defined( 'WCWOOPRICELY_VERSION' ) ) {
    define( 'WCWOOPRICELY_VERSION', 'v1.3.8' );
}

require_once (dirname( __FILE__ ) . '/framework/reon_loader.php');

if ( !class_exists( 'WCWooPricely_Plugin' ) ) {

    class WCWooPricely_Plugin {

        public function __construct() {

            if ( $this->is_plugin_active( 'woocommerce.php' ) ) {

                load_plugin_textdomain( 'zcpri-woopricely', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

                include_once('extensions/extensions.php');
            }
        }

        private function is_plugin_active( $plugin_filename ) {

            $active_plugins = ( array ) get_option( 'active_plugins', array() );

            foreach ( $active_plugins as $active_plugin ) {

                if ( stripos( $active_plugin, $plugin_filename ) ) {

                    return true;
                }
            }

            if ( !is_multisite() ) {

                return false;
            }

            $active_site_plugins = get_site_option( 'active_sitewide_plugins' );

            $active_plugins_keys = array_keys( $active_site_plugins );

            foreach ( $active_plugins_keys as $active_plugins_key ) {

                if ( stripos( $active_plugins_key, $plugin_filename ) ) {

                    return true;
                }
            }

            return false;
        }

    }

    new WCWooPricely_Plugin();
}
