<?php  
/** 
* Plugin Name: Notifier for Phone
* Plugin URI: https://qodrbee.com/notifierforphone
* Description: Tool for connect Woocommerce with Whatsapp Notifier
* Version: 0.5.3
* Author: QODR
* Author URI: https://qodrbee.com 
* License: GPL-2.0+   
* License URI: http://www.gnu.org/licenses/gpl-2.0.txt 
* 27-01-2020
*/ 
 

if ( ! defined( 'WPINC' ) ) { 
     die('..');
}

include_once("config/inc.php");

function nwa_premium_helper_menu(){ 
	add_menu_page(
		__( 'Notifier for Phone', 'Notifier for Phone' ),
		PLUGIN_NAME,
        'manage_options',
        'notifierforphone-main-menu',
        'nwa_main',
        NWA_URI.'public/img/logo_notifier_1.png',
        54  
	);

	$active_sitewide_plugins=array();
	if (get_site_option('active_sitewide_plugins')!==false) {
		$active_sitewide_plugins=get_site_option('active_sitewide_plugins');
	}

	if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins'))) || in_array('woocommerce/woocommerce.php', array_keys($active_sitewide_plugins))) {
		add_submenu_page('notifierforphone-main-menu', 'Template for Woocommerce', 'Template for Woocommerce', 'manage_options', 'notifierforphone-woocommerce', 'nwa_woocommerce');
	}

	add_submenu_page('notifierforphone-main-menu', 'Custom Form', 'Custom Form', 'manage_options', 'notifierforphone-customform', 'nwa_custom_form');

	$customfilename = NWA_PATH.'modules/custom_features/custom_features.php';
	if (file_exists($customfilename)) {
		// add_submenu_page('notifierforphone-main-menu', 'Custom Features', 'Custom Features', 'manage_options', 'notifierforphone-custom-features', 'nwa_custom_features');
	}
}

function nwa_active_plugin() {


}

function nwa_deactive_plugin() {


}

function my_plugin_init() {
	load_plugin_textdomain( 'notifier-for-phone', false, dirname( plugin_basename( __FILE__ )) . '/languages' );
}
add_action('init', 'my_plugin_init');