<?php 

namespace nwa\Modules;

class ReminderOrder2 {

	/**
	 * set reminder order after checkout
	 * hooked via action woocommerce_thankyou, priority 10
	 * @param int $order_id
	 * @return void
	 */
	public function set_reminder_order_after_checkout( $order_id ) {
		if ( ! $order_id )
			return;
			
		if (get_option(PLUGIN_PREFIX.'_toggle_reminder_order') == 'checked'):
			// Allow code execution only once 
			if ( ! get_post_meta( $order_id, '_thankyou_action_done', true ) ) :
				$this->set_cron_action_scheduler( $order_id, 0 );
				update_post_meta( $order_id, '_thankyou_action_done', true );
			endif;
		endif;
	}

	/**
	 * set cron action scheduler
	 * @param int $order_id
	 * @param int $kirim_wa_ke
	 * @return void
	 */
	public function set_cron_action_scheduler( $order_id, $kirim_wa_ke = 0 ) {
		$timezone = get_option('timezone_string');
		if (empty($timezone) or $timezone == '') {
			// $timezone="Asia/Jakarta";
		} else {
			date_default_timezone_set($timezone);
		}
	

		$post = get_post( $order_id );

		if ( is_a( $post,'WP_Post' ) && $post->post_type === 'shop_order' ) :
			$batas_reminder = get_option("on_hold_reminder");
			if (empty($batas_reminder)) :
				$batas_reminder = 2;
			endif;
		
			$type = get_option(PLUGIN_PREFIX."_on_hold_reminder_type");
			if (empty($type)) :
				$type = "day";
			endif;
			
			$add_minutes = 0;
		
			switch ( $type ) {
				case 'day':
					$add_minutes = $batas_reminder*24*60;
					break;
		
				case 'hour':
					$add_minutes = $batas_reminder*60;
					break;
			}

			$timestamp = strtotime( 'now +'. $add_minutes .' minutes' );
			$hook = 'nwa_reminder_order_scheduler2';
			$args = [
				[
					'order_id' 		=> $order_id,
					'kirim_wa_ke'	=> $kirim_wa_ke,
				]
			];
			$group = 'nwa_scheduler';
	
			if ( false === as_next_scheduled_action( $hook, $args, $group ) ) :
				as_schedule_single_action( $timestamp, $hook, $args, $group );
			endif;
		endif;

	}

	/**
	 * send reminder order
	 * hooked via action nwa_reminder_order_scheduler, priority 10
	 * @param array $data
	 * @return void
	 */
	public function send_reminder_order( $data ) {
		$toggle_reminder_order = get_option(PLUGIN_PREFIX.'_toggle_reminder_order');
		$ke = $data['kirim_wa_ke'];
		if ( isset( $data['order_id'] ) && $toggle_reminder_order === 'checked' ) :
			$order = wc_get_order( $data['order_id'] );
			if ( is_a( $order,'WC_Order' ) && in_array( $order->get_status(), ['on-hold','pending'] ) && $toggle_reminder_order != '') :
				$bulk_template = update_post_meta($data['order_id'], 'bulk_template', $ke);
				nwa_send_force_reminder_order( $data['order_id'],'reminder_order');
				if ( get_option(PLUGIN_PREFIX.'_reminder_loop') ) :
					$i = get_post_meta( $data['order_id'], 'kirim_wa_ke', true );
					if ($i >= 3) :
						$ke = 3; 
					else :
						$ke = $i+1;
					endif;
					update_post_meta( $data['order_id'],'kirim_wa_ke', $ke );
					if ( $i < 3 ) :
						$this->set_cron_action_scheduler( $data['order_id'], $ke );
					endif;
					// tambah validasi untuk repeat template 3

				endif;
			endif;
		endif;
	}
}