<?php

nwa_hook_wpajax('file_upload');
nwa_hook_wpajax('save_pending_payment');
nwa_hook_wpajax('onoff_pending_payment');

// add_action('woocommerce_order_status_pending', 'nwa_sendapi_pending_payment', 10, 1);
function nwa_send_customer_pending_payment( $order_id, $type = 'pending_payment'){
    if (get_option(PLUGIN_PREFIX.'_license_type') == 'multivendor') {
        nwa_sendapi($order_id, $type);
    }else {
        $main_customer = new MainCustomer();
        $data = $main_customer->get_setting($order_id, $type = 'pending_payment');
        $main = new Main();
        if ($data['flow'] == true){
            $data_order = $main->get_data_order($order_id, $type);
            $data = $main->send_message($data_order);
            if ($data_order['data_api']['file'] != '') {
                $main->send_image($data_order);
            }
        }
        
        $main->writelog($data['log']);
    }
}
add_action('woocommerce_order_status_pending', 'nwa_send_customer_pending_payment', 10, 1);

function nwa_send_seller_pending_payment( $order_id, $type = 'pending'){
    if (get_option(PLUGIN_PREFIX.'_license_type') == 'multivendor') {
        nwa_sendapi($order_id, $type);
    }else {
        $main_seller = new MainSeller();
        $data = $main_seller->get_setting($order_id, $type = 'pending');
        $main = new Main();
        if ($data['flow'] == true){
            $data = $data['wa_number'];
            foreach ($data as $key => $no_wa) {
                $data_order  = $main->get_data_order($order_id, 'seller_notification'.$type);
                $data_order['no_wa_tujuan'] = $no_wa;

                $data = $main->send_message($data_order);
                if ($data_order['data_api']['file'] != '') {
                    $main->send_image($data_order);
                }

                $main->writelog($data['log']);
            }
        }     
    }
}
add_action('woocommerce_order_status_pending', 'nwa_send_seller_pending_payment', 10, 1);