<?php 

namespace nwa\Modules;


class OrderCompletedFollowup {

	/**
	 * set reminder order after checkout
	 * hooked via action woocommerce_thankyou, priority 10
	 * @param int $order_id
	 * @return void
	 */
	public function set_reminder_order_completed_followup( $order_id ) {
		if ( ! $order_id )
			return;
			
            if (get_option(PLUGIN_PREFIX.'_toggle_order_complete_followup') == 'checked'){
                // Allow code execution only once 
                $order = wc_get_order( $order_id );
                $order_status  = $order->get_status();
                if ( $order_status == 'completed' ){
				    $this->set_cron_action_scheduler( $order_id, 'order_complete_followup' );
                }
            }else {
                nwa_writelog('Order Completed Followup toggle is OFF');
            }
	}

	/**
	 * set cron action scheduler
	 * @param int $order_id
	 * @param int $kirim_wa_ke
	 * @return void
	 */
	public function set_cron_action_scheduler( $order_id, $type = 'order_complete_followup' ) {
        if (get_option(PLUGIN_PREFIX.'_license_type') != 'crm' && get_option(PLUGIN_PREFIX.'_license_type') != 'multics') {
            $data = [
                'order_id' => $order_id,
                'type_order'     => $type,
            ];

            $this->send_order_completed_followup($data);

            return;
        }

        $timezone = get_option('timezone_string');
		if (empty($timezone) or $timezone == '') {
			// $timezone="Asia/Jakarta";
		} else {
			date_default_timezone_set($timezone);
		}

		$post = get_post( $order_id );
		if ( is_a( $post,'WP_Post' ) && $post->post_type === 'shop_order' ) :
			$time_limit = get_option(PLUGIN_PREFIX."_time_limit_followup_order_completed");
			if (empty($time_limit)) :
				$time_limit = 2;
			endif;
            
			$time_type = get_option(PLUGIN_PREFIX."_time_type_followup_order_completed");
			if (empty($time_type)) :
				$time_type = "day";
			endif;
			
			$add_minutes = 0;
            
			switch ( $time_type ) {
                case 'day':
					$add_minutes = $time_limit*24*60;
					break;
                    
                case 'hour':
					$add_minutes = $time_limit*60;
					break;
			}

			$timestamp = strtotime( 'now +'. $add_minutes .' minutes' );
			$hook = 'nwa_order_completed_followup';
			$args = [
				[
					'order_id' 		=> $order_id,
					'timestamp'	=> $timestamp,
					'type_order'	=> 'order_complete_followup',
				]
			];
			$group = 'nwa_scheduler';
	
			if ( false === as_next_scheduled_action( $hook, $args, $group ) ) :
                nwa_writelog('ORDER COMPLETED FOLLOWUP message for order id #'.$order_id.' will be send at ' . date('d-m-y H:i', $timestamp) . ' Please make sure to access the website around that time');
				as_schedule_single_action( $timestamp, $hook, $args, $group );
			endif;
		endif;

	}

	/**
	 * send reminder order
	 * hooked via action nwa_reminder_order_scheduler, priority 10
	 * @param array $data
	 * @return void
	 */
	public function send_order_completed_followup( $data ) {
        $order_id = $data['order_id'];
        $type = $data['type_order'];
		
        nwa_order_complete_followup($order_id, $type);

	}

}