<?php

nwa_hook_wpajax('save_order_complete');
nwa_hook_wpajax('onoff_order_complete');
nwa_hook_wpajax('order_completed_message');

function nwa_send_order_completed( $order_id, $type = "order_complete" ){

    if (get_option(PLUGIN_PREFIX.'_license_type') == 'multivendor') {
        nwa_sendapi($order_id, $type);
    }else {
        $main_customer = new MainCustomer();
        $data = $main_customer->get_setting($order_id, $type);
        $main = new Main();
        if ($data['flow'] == true){
            $data_order = $main->get_data_order($order_id, $type);
            if ($data_order['data_api']['file'] != '') {
                $main->send_image($data_order);
            }
            $data = $main->send_message($data_order);
        }
        $main->writelog($data['log']);
    }
}
add_action('woocommerce_order_status_completed', 'nwa_send_order_completed', 10, 1);

function nwa_send_seller_completed( $order_id, $type = 'completed'){
    if (get_option(PLUGIN_PREFIX.'_license_type') == 'multivendor') {
        nwa_sendapi($order_id, $type);
    }else {
        $main        = new Main();
        $main_seller = new MainSeller();
        $data        = $main_seller->get_setting($order_id, $type);
        if ($data['flow'] == true){
            $data = $data['wa_number'];
            foreach ($data as $key => $no_wa) {
                $data_order  = $main->get_data_order($order_id, 'seller_notification'.$type);
                $data_order['no_wa_tujuan'] = $no_wa;
                
                $data = $main->send_message($data_order);
                
                if ($data_order['data_api']['file'] != '') {
                    $main->send_image($data_order);
                }

                $main->writelog($data['log']);
            }
        }
    }
}
add_action('woocommerce_order_status_completed', 'nwa_send_seller_completed', 10, 1);

function nwa_order_complete_followup($order_id, $type = 'order_complete_followup'){
    $main_customer = new MainCustomer();
    $data = $main_customer->get_setting($order_id, $type);
    $main = new Main();
    if ($data['flow'] == true){
        $data_order = $main->get_data_order($order_id, $type);
        if (get_option(PLUGIN_PREFIX.'_toggle_order_complete_followup') == 'checked' && get_option(PLUGIN_PREFIX.'_license_type') == ''  && get_option(PLUGIN_PREFIX.'_license_type') != 'crm' && get_option(PLUGIN_PREFIX.'_license_type') != 'multics') {
            if ($data_order['file'] != '') {
                $data = $main->send_schedule_message($data_order);
                $data = $main->send_schedule_image($data_order);
            }
            
            if ($data['response'] == 'sch_more_than_3_in_1_minute') {
                $data = $main->send_schedule_message($data_order);
                if ($data_order['data_api']['file'] != '') {
                    $data = $main->send_schedule_image($data_order);
                }
            }
            
            $main->writelog($data['log']);
        }else {
            $data = $main->send_message($data_order);
            if ($data_order['data_api']['file'] != '') {
                $data = $main->send_image($data_order);
            }
            
            $main->writelog($data['log']);
        }
    }

}

// add_action('woocommerce_order_status_completed', 'nwa_order_complete_followup', 10, 1);