<?php

function nwa_remove_metadata($protected, $meta_key) {
    if ( in_array( $meta_key, array( 'cs_rotator', 'bulk_template', 'kirim_wa_ke', 'kirim_wa', 'reminder_time_terakhir', 'terakhir_kirim_wa', 'nwa_apk_order', 'follow_up', 'follow_up_send', 'nwa_meta_box_slug' ) ) ) {
        return true;
    }

    return $protected;
}

function spin_text($text) {
    preg_match_all("/\[([^\]]*)\]/", $text, $matches);
    $matches_replace = array_map('get_spin', $matches[1]);
    
    $output = str_replace($matches[0], $matches_replace, $text);
    return $output;
}

function get_spin($text)
{
    $text = htmlspecialchars(strip_tags(trim($text)));
    $arr = explode('|', $text);
    $index = rand(0, count($arr) -1);
    $output = $arr[$index];
    
    return $output;
}

function nwa_customer_note($dt){

    $sendwa = get_option('sendwa');

	if (get_option(PLUGIN_PREFIX.'_checkbox_customer_note_sendwa') != 'true') {
        return false;
    }
    
    $data_api['text'] = $dt['customer_note'];
    $data_api['license'] = get_option(PLUGIN_PREFIX.'_license_number');
    $site_url = get_site_url();
    $site_url = str_replace('https://', '', $site_url);
    $site_url = str_replace('http://', '', $site_url);
    $site_url = str_replace('www.', '', $site_url);
    $site_url_arr = explode('/', $site_url);

    if (is_array($site_url_arr)) {
        $site_url = $site_url_arr[0];
    }

    $data_api['domain'] = $site_url;
    $data_api['tipe'] = 'customer_note';
    $order_id = $dt['order_id'];
    $order = wc_get_order($order_id);

    $postmetas = get_post_meta($order_id);

    foreach($postmetas as $meta_key=>$meta_value) {
        $$meta_key = $meta_value[0];
    }

    $billing_phone = $order->get_billing_phone();
    $billing_country = $order->get_billing_country();

    $no_wa_tujuan = nwa_validasi_nomor($billing_phone, $billing_country);
    
    $data_api['no_wa_tujuan'] = $no_wa_tujuan;

    (get_post_meta($order_id, 'cs_rotator', true)) ? update_post_meta($order_id, 'cs_rotator', 'belum') : add_post_meta($order_id, 'cs_rotator', 'belum');

    if(get_option(PLUGIN_PREFIX.'_license_type') == 'android'){
        if(get_option(PLUGIN_PREFIX."_toggle_cs_rotator") != '') {
            $kirim='ok';
        }
    
        if ($kirim=='ok') {
            $datacs = get_option(PLUGIN_PREFIX.'_customer_service_data');
            $dt_cs = json_decode($datacs,1);
            $jmlh = count($dt_cs);
    
            if ( get_option(PLUGIN_PREFIX.'_current_cs_rotator') != true ) { add_option(PLUGIN_PREFIX.'_current_cs_rotator',1);}
    
            if (get_option(PLUGIN_PREFIX.'_current_cs_rotator') > $jmlh) {
                update_option(PLUGIN_PREFIX.'_current_cs_rotator', 1);
                nwa_writelog(__('List CS now start from 1', 'notifier-for-phone'));
            }
    
            $dt_cs = array_values($dt_cs);
            foreach ($dt_cs as $k_cs => $v_cs){
                $current_cs_rotator=get_option(PLUGIN_PREFIX.'_current_cs_rotator');
                $cs_id = $k_cs+1;
                $wa_cs = $no_wa_tujuan;
                $player_id = $v_cs['player_id'];
    
                if ($current_cs_rotator == $cs_id) {
                    if (!empty(get_option(PLUGIN_PREFIX.'_toggle_customer_service'.$current_cs_rotator))){
                        if (get_post_meta($order_id, 'cs_rotator', true) == 'belum' ) {
                            nwa_send_api_cs($data_api, $order_id, $data_api['text'], $billing_country, $wa_cs, $player_id, $v_cs['name']);
                            $next_cs_rotator = $current_cs_rotator+1;
                            update_option(PLUGIN_PREFIX.'_current_cs_rotator', $next_cs_rotator);
                            if (get_post_meta($order_id, 'nwa_apk_order', TRUE) == 'kosong') {
                            }
                            update_post_meta($order_id, 'nwa_apk_order', $player_id);
                            update_post_meta($order_id, 'cs_rotator', 'sudah');
                        }
                    }else {
                        $next_cs_rotator = $current_cs_rotator+1;
                        update_option(PLUGIN_PREFIX.'_current_cs_rotator', $next_cs_rotator);
    
                        if ($next_cs_rotator > $jmlh) {
                            update_option(PLUGIN_PREFIX.'_current_cs_rotator', 1);
                            $next_cs_rotator = get_option(PLUGIN_PREFIX.'_current_cs_rotator');
    
                            if ($next_cs_rotator == $cs_id){
                                if (!empty(get_option(PLUGIN_PREFIX.'_toggle_customer_service'.$next_cs_rotator))) {
                                    if (get_post_meta($order_id, 'cs_rotator', true) == 'belum' ) {
                                        nwa_send_api_cs($data_api, $order_id, $data_api['text'], $billing_country, $wa_cs, $player_id, $v_cs['name']);
    
                                        $last_cs_rotator = $next_cs_rotator+1;
                                        update_option(PLUGIN_PREFIX.'_current_cs_rotator', $last_cs_rotator);
                                        if (get_post_meta($order_id, 'nwa_apk_order', TRUE) == 'kosong') {
                                        }
                                        update_post_meta($order_id, 'cs_rotator', 'sudah');
                                        update_post_meta($order_id, 'nwa_apk_order', $player_id);
                                    }
                                }else {
                                    $last_cs_rotator = $next_cs_rotator+1;
                                    update_option(PLUGIN_PREFIX.'_current_cs_rotator', $last_cs_rotator);
                                }
                            }
                        }
                    }
                }
            }
        }
    }else {
        nwa_curl_post($data_api, $order_id);
    }
}

function nwa_file_upload(){
    $namafile = $_FILES['file']['name'];
    $upload = wp_upload_bits($namafile, null, file_get_contents($_FILES['file']['tmp_name']));
    $dir = wp_upload_dir();
    $urlgambar = $dir['url']."/$namafile";
    wp_die($urlgambar);
}

function nwa_form($order_id, $tipe){
    $order = wc_get_order($order_id);
    foreach ($order->get_items() as $item_key => $item_values):
        $item_id           = $item_values->get_id();
        $item_name         = $item_values->get_name();
        $item_data         = $item_values->get_data();
        $item_type         = $item_values->get_type();
        $product           = $item_values->get_product();
        $product_id        = $item_values->get_product_id();
        $product_link      = get_permalink($product_id);
        $product_links[]   = get_permalink($product_id);
        $line_total        = $item_data['total'];
        $quantity          = $item_data['quantity'];
        $line_subtotal     = $item_data['subtotal'];
        $line_total_tax    = $item_data['total_tax'];
        $tax_class         = $item_data['tax_class'];
        $product_id        = $item_data['product_id'];
        $line_subtotal_tax = $item_data['subtotal_tax'];
        $variation_id      = $item_data['variation_id'];
		$variation_text	   ='';

        if( $product->is_type('variation') ){
            $variation_attributes = $product->get_variation_attributes();
			
			foreach ($item_values->get_meta_data() as $metaData) {
				$attribute = $metaData->get_data();
				$value = $attribute['value'];
				if ($value) {
					$variation_text .= "$value, ";	
				}
			}
			$product_variations[$item_id] = rtrim($variation_text,',');
        }

        foreach ($product_variations as $key_var => $val_var) {
            $val_var = trim($val_var,', ');
            if ($key_var == $item_id) {
                $Arrproduct_name[]      = $item_data['name'].', x '.$quantity;
            }
        }
        
        $Arrproduct_name_link[] = $item_data['name'].' x '.$quantity."\n".$product_link;
    endforeach;
    
    $ast_no_resi          = get_post_meta($order_id , '_wc_shipment_tracking_items', true )[0]['tracking_number'];
    // $ast_link_tracking    = 'https://resi.id/s/'.$ast_no_resi;

    $postmetas = get_post_meta($order_id);

    foreach($postmetas as $meta_key=>$meta_value) {
        $$meta_key = $meta_value[0];
    }

    $ast_no_resi          = get_post_meta($order_id , '_wc_shipment_tracking_items', true );
    $ast_no_resi		  = $ast_no_resi[0]['tracking_number'];
    $ast_courier          = get_post_meta($order_id , '_wc_shipment_tracking_items', true );
    $ast_courier	      = $ast_courier[0]['tracking_provider'];

    $delivery_type = get_post_meta($order_id, '_byconsolewooodtrestro_order_type', true);
    
    if ($delivery_type == 'dinein') {
        $delivery_type = 'Dine in';
    }else if($delivery_type == 'levering'){
        $delivery_type = 'Delivery';
    }else{
        $delivery_type = 'Pick up';
    }

    $delivery_date = get_post_meta($order_id, '_byconsolewooodtrestro_delivery_date', true);
    $delivery_time = get_post_meta($order_id, '_byconsolewooodtrestro_delivery_time', true);
    
    $shipping = $order->get_items( 'shipping' );
    $resi     = get_post_meta($order_id , '_indo_ongkir_resi', true );

    $array_recipt = [];
    $array_recipt_after = [];

    foreach ($shipping as $item_id => $item) {
        $item_resi = isset( $resi[$item_id] ) ? $resi[$item_id] : '';
        $x = $item->get_name();
        $y = $item_resi;
        $z = $item->get_total();

        $meta_items1 = $item->get_meta( 'Items' );
        $meta_items = str_replace("&times;", "x", $meta_items1);
        if ($meta_items == '' || empty($meta_items)) {
            $meta_items = $product_name;
        }

        $array_recipt_after[] = "Produk : ".$meta_items."\r\nExpedisi : ".$x."\r\nTarif Ongkir : ".$z;
        $array_recipt[] = "Produk : ".$meta_items."\r\nExpedisi : ".$x."\r\nTarif Ongkir : ".$z."\r\nNo. Resi : ".$y;
    }
    $payment_url   = get_post_meta($order_id , 'Xendit_invoice_url', true );
        
    if (empty(get_post_meta($order_id , 'Xendit_invoice_url', true ))) {
        $payment_url = $order->get_meta('_mt_payment_url');
    }
    $nwa_courier = get_post_meta($order_id, 'nwa_meta_box_courier', true);
    $nwa_additional_info = get_post_meta( $order_id, 'nwa_meta_box_slug', true );
    $aftership_courier = get_post_meta($order_id, '_aftership_tracking_provider_name', true);
    $nwa_tracking_number = get_post_meta($order_id, 'nwa_meta_box_tracking_number', true);
    $aftership_tracking_number = get_post_meta($order_id, '_aftership_tracking_number', true);

    $indo_ongkir_resi = implode("\r\n\r\n", $array_recipt);
    $indo_ongkir = implode("\r\n\r\n", $array_recipt_after);

    if (!empty($Arrproduct_name_link)) {
        $product_name_link = implode("\n", $Arrproduct_name_link);
    } else {
        $product_name_link = '';
    }
    
    if (!empty($product_links)) {
        $product_link = implode("\n", $product_links);
    } else {
        $product_link = '';
    }
    
    if (!empty($Arrproduct_name)) {
        $product_name = implode("\n", $Arrproduct_name);
    } else {
        $product_name = '';
    }
    
    $shipping_add = [
        'firstname' => $order->get_shipping_first_name(),
        'lastname' => $order->get_shipping_last_name(),
        'address1' => $order->get_shipping_address_1(),
        'address2' => $order->get_shipping_address_2(),
        'city' => $order->get_shipping_city(),
        'zipcode' => $order->get_shipping_postcode(),
        'total' => $order->get_total(),
        'state_name' => $order->get_shipping_state(),
        'country' => $order->get_shipping_country(),
    ];

    $data                 = $order->get_data();
    $status               = $order->get_status();
    $version              = $order->get_version();
    $currency             = $order->get_currency();
    $parent_id            = $order->get_parent_id();
    $date_created         = $order->get_date_created();
    $order_comments       = $order->get_customer_note();
    $payment_method       = $order->get_payment_method();
    $id                   = $order->get_transaction_id();
    $payment_method_title = $order->get_payment_method_title();

    $shipping_method      = $order->get_shipping_method();

    (isset($date_created)) ? $order_date_created = date( 'j F Y, g:i a', $order->get_date_created ()->getOffsetTimestamp()) : $order_date_created = '';

    $date_modified = $order->get_date_modified();
    (isset($date_modified)) ? $timestamp_modified = $date_modified->getTimestamp() : $timestamp_modified = '';
    
    $discount_total = $order->get_discount_total();
    $discount_tax = $order->get_discount_tax();
    $shipping_total = $order->get_shipping_total();
    $shipping_tax = $order->get_shipping_tax();
    $total = $order->get_cart_tax();
    $total_tax = $order->get_total_tax();
    $customer_id = $data['customer_id'];

    //# BILLING INFORMATION:
    $billing_first_name = $order->get_billing_first_name();
    $billing_last_name = $order->get_billing_last_name();
    $billing_company = $order->get_billing_company();
    $billing_address_1 = $order->get_billing_address_1();
    $billing_address_2 = $order->get_billing_address_2();
    $billing_city = $order->get_billing_city();
    $billing_state = $order->get_billing_state();
    $billing_postcode = $order->get_billing_postcode();
    $billing_country = $order->get_billing_country();
    $billing_email = $order->get_billing_email();
    $billing_phone = $order->get_billing_phone();

    if (empty($billing_country) || $billing_country == '') {
        $billing_country = WC()->countries->get_base_country();
    }

    $billing_state = WC()->countries->get_states( $billing_country )[$billing_state_code];

    $total_bayar  = number_format($shipping_add['total'], wc_get_price_decimals(), wc_get_price_decimal_separator(), wc_get_price_thousand_separator());
    $total_amount = trim($total_bayar);

    //# SHIPPING INFORMATION:

    $shipping_first_name = $order->get_shipping_first_name();
    $shipping_last_name = $order->get_shipping_last_name();
    $shipping_company = $order->get_shipping_company();
    $shipping_address_1 = $order->get_shipping_address_1();
    $shipping_address_2 = $order->get_shipping_address_2();
    $shipping_city = $order->get_shipping_city();
    $shipping_state = $order->get_shipping_state();
    $shipping_postcode = $order->get_shipping_postcode();
    $shipping_country = $order->get_shipping_country();
    $methods = WC()->payment_gateways->payment_gateways();
    $bacs_class = $methods['bacs'];
    $no_rek_all = "\n";

    foreach ($bacs_class->account_details as $k => $v) {
        $count = $k + 1;
        $a = "nama_rek$count";
        $$a = $bacs_class->account_details[$k]['account_name'];
        $b = "nama_bank$count";
        $$b = $bacs_class->account_details[$k]['bank_name'];
        $c = "no_rek$count";
        $$c = $bacs_class->account_details[$k]['account_number'];
        $no_rek_all .= 'Rek : '.$$b.' '.$$c.' a.n : '.$$a."\n\n";

        $a = "account_name$count";
        $$a = $bacs_class->account_details[$k]['account_name'];
        $b = "bank_name$count";
        $$b = $bacs_class->account_details[$k]['bank_name'];
        $c = "account_number$count";
        $$c = $bacs_class->account_details[$k]['account_number'];
    }

    $reminder_diff_template = get_option(PLUGIN_PREFIX.'_reminder_diff_template');

    if ($tipe == 'reminder_order') {
        $bulk_template = get_post_meta($order_id, 'bulk_template', true);
        if (!empty($bulk_template)) {
            for ($i = 0; $i < 4; ++$i) {
                if ($bulk_template == 0) {
                    $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_reminder_order');

                    if (!empty(get_option(PLUGIN_PREFIX.'_check_reminder_order'))) {
                        $data_api['file'] = get_option(PLUGIN_PREFIX.'_pesan_reminder_order_gambar');
                    } else {
                        $data_api['file'] = '';
                    }

                    update_post_meta($order_id, 'bulk_template', '');
                } elseif ($bulk_template == $i) {
                    $rp_Pesan = get_option(PLUGIN_PREFIX."_pesan_reminder_order$i");

                    if (!empty(get_option(PLUGIN_PREFIX."_check_reminder_order$i"))) {
                        $data_api['file'] = get_option(PLUGIN_PREFIX."_pesan_reminder_order_gambar$i");
                    } else {
                        $data_api['file'] = '';
                    }

                    update_post_meta($order_id, 'bulk_template', '');
                }
            }
        } else {
            $set_pesan = get_post_meta($order_id, 'kirim_wa_ke', true);
            if ($set_pesan == 0) {
                $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_reminder_order');
                if (!empty(get_option(PLUGIN_PREFIX.'_check_reminder_order'))) {
                    $data_api['file'] = get_option(PLUGIN_PREFIX.'_pesan_reminder_order_gambar');
                } else {
                    $data_api['file'] = '';
                }
            } else {
                $i = $set_pesan;
                $rp_Pesan = get_option(PLUGIN_PREFIX."_pesan_reminder_order$i");
                if (!empty(get_option(PLUGIN_PREFIX."_check_reminder_order$i"))) {
                    $data_api['file'] = get_option(PLUGIN_PREFIX."_pesan_reminder_order_gambar$i");
                } else {
                    $data_api['file'] = '';
                }
            }
        }
    } else {
        if ($tipe == 'after_checkout') {
            $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan');
        } else {
            $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_'.$tipe);
        }
    }

    $customfilename = NWA_PATH.'modules/custom_features/custom_features.php';
    if (file_exists($customfilename)) {
        if (get_option(PLUGIN_PREFIX.'_toggle_order_completed_custom') == 'checked') {
            if ($tipe == 'order_complete') {
                $json = get_option(PLUGIN_PREFIX.'_oc_custom_features_data');
                $arrray_customfeatures = json_decode($json);
                
                foreach ($arrray_customfeatures as $key => $value) {
                    if (strtolower($value->title) == strtolower($shipping_method)) {
                        $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_oc_custom_features'.$key);
                    }
                }
            }
        }
    }
    if (file_exists($customfilename)) {
        if (get_option(PLUGIN_PREFIX.'_toggle_pending_payment_custom') == 'checked') {
            if ($tipe == 'pending_payment') {
                $json = get_option(PLUGIN_PREFIX.'_pp_custom_features_data');
                $arrray_customfeatures = json_decode($json);
                
                foreach ($arrray_customfeatures as $key => $value) {
                    if (strtolower($value->title) == strtolower($payment_method_title)) {
                        $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_pp_custom_features'.$key);
                    }
                }
            }
        }
    }

    if ($tipe == 'ro_custom_features') {
        $bulk_template = get_post_meta($order_id, 'bulk_template', true);
        if (!empty($bulk_template)) {
            $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_'.$tipe.$bulk_template);
            if (!empty(get_option(PLUGIN_PREFIX.'_check_'.$tipe.$bulk_template))) {
                $data_api['file'] = get_option(PLUGIN_PREFIX.'_image_'.$tipe.$bulk_template);
            } else {
                $data_api['file'] = '';
            }
            
            update_post_meta($order_id, 'bulk_template', '');
        }
    }

    $rp_Pesan=str_replace("'","",$rp_Pesan);
    $rp_Pesan=str_replace('"',"",$rp_Pesan);
    $rp_Pesan=str_replace('$',"",$rp_Pesan);

    $checkbox_followup = get_option(PLUGIN_PREFIX.'_checkbox_followup');
    $time_followup = get_option(PLUGIN_PREFIX.'_order_completed_followup');
    $followup_type = get_option(PLUGIN_PREFIX.'_order_completed_followup_type');
    $today = date("Y-m-d");

    if ($tipe == 'order_complete' && $checkbox_followup != '') {
        if ($followup_type == 'day') {
            $send_followup = date('Y-m-d', strtotime($today .'+'. $time_followup.' days'));
            (get_post_meta($order_id, 'follow_up', true)) ? update_post_meta($order_id, 'follow_up', $send_followup) : add_post_meta($order_id, 'follow_up', $send_followup);
            (get_post_meta($order_id, 'follow_up_send', true)) ? NULL : add_post_meta($order_id, 'follow_up_send', 'belum');
        }else {
            $send_followup = date('Y-m-d H:i:s', strtotime($today .'+'. $time_followup.' hours'));
            (get_post_meta($order_id, 'follow_up_send', true)) ? NULL : add_post_meta($order_id, 'follow_up_send', 'belum');
            (get_post_meta($order_id, 'follow_up', true)) ? update_post_meta($order_id, 'follow_up', $send_followup) : add_post_meta($order_id, 'follow_up', $send_followup);
        }
    }

    $site_url = get_site_url();

    if ( !empty($product_id) || $product_id != "" ) {
        
        $product_digital = get_post_meta($product_id);

        if ( !empty($product_digital['_downloadable_files'][0]) || $product_digital['_downloadable_files'][0] !== "" ) {
            $downloadFileUnserialize = unserialize($product_digital['_downloadable_files'][0]);
            
            $linkFile = "";

            $i = 0;
            foreach ($downloadFileUnserialize as $k => $v) {
                $linkFile .= $v['file'] . ", ";
                $i++;
            }
            
            $product_digital_link = substr($linkFile, 0, -2);
        }

    }

    $rp_Pesan = str_replace('{', '$', $rp_Pesan);
    $rp_Pesan = str_replace('}', '', $rp_Pesan);
    $pesan_eval = '$isi="'.$rp_Pesan.'";';
    eval($pesan_eval);

    $all_bank_account = $no_rek_all;

    $no_wa_tujuan = nwa_validasi_nomor($billing_phone, $billing_country);

    $data_api['text'] = $isi;
    $data_api['license'] = get_option(PLUGIN_PREFIX.'_license_number');
    $site_url = str_replace('https://', '', $site_url);
    $site_url = str_replace('http://', '', $site_url);
    $site_url = str_replace('www.', '', $site_url);
    $site_url_arr = explode('/', $site_url);

    if (is_array($site_url_arr)) {
        $site_url = $site_url_arr[0];
    }

    $data_api['domain'] = $site_url;
    $data_api['tipe'] = $tipe;
    $data_api['no_wa_tujuan'] = $no_wa_tujuan;

    if ($tipe != 'reminder_order') {
        if (!empty(get_option(PLUGIN_PREFIX."_check_$tipe"))) {
            if (!empty(get_option(PLUGIN_PREFIX."_image_$tipe"))) {
                $data_api['file'] = get_option(PLUGIN_PREFIX."_image_$tipe"); 
            }
        } else {
            $data_api['file'] = '';
        }
    }

    $bdata = array(
        'kota' => $billing_city,
        'produk' => $product_name,
        'nama_pembeli' => "$billing_first_name $billing_last_name",
        'email' => $billing_email,
        'no_hp' => $billing_phone,
        'provinsi' => $billing_state,
        'negara' => $billing_country,
        'alamat' => "$billing_address_1 $billing_address_2",
        'kodepos' => $billing_postcode,
    );

    $data_api['bdata'] = json_encode($bdata);

    $return['data_api'] = $data_api;
    $return['order_id'] = $order_id;
    $return['isi'] = $isi;
    $return['billing_country'] = $billing_country;
    $return['no_wa_tujuan'] = $no_wa_tujuan;

    return $return;
}

function nwa_sendapi($order_id, $tipe = 'after_checkout'){
    
    $form = nwa_form($order_id, $tipe);
    extract($form);
    $kirim = 'no';
    if (get_option(PLUGIN_PREFIX.'_checkbox_wa_notif') == 'checked=checked') {
        if (!empty(get_post_meta($order_id, 'nwa_checkbox_notification', true))) {
            if (get_option(PLUGIN_PREFIX."_toggle_$tipe") != '') {
                $kirim = 'ok';
            }
        } else {
            nwa_writelog("#$order_id ". __('Your Message Failed to Send Because Your Customer don\'t want to receive the message!', 'notifier-for-phone'));
        }
    } else {
        if (get_option(PLUGIN_PREFIX."_toggle_$tipe") != '') {
            $kirim = 'ok';
        }
    }

    if ($kirim == 'ok') {
        (get_post_meta($order_id, 'kirim_wa_ke', true)) ? NULL : update_post_meta($order_id, 'kirim_wa_ke', 0);
        (get_post_meta($order_id, 'cs_rotator', true)) ? update_post_meta($order_id, 'cs_rotator', 'belum') : add_post_meta($order_id, 'cs_rotator', 'belum');
        (get_post_meta($order_id, 'terakhir_kirim_wa', true)) ? update_post_meta($order_id, 'terakhir_kirim_wa', date('Y-m-d H:i:s')) : add_post_meta($order_id, 'terakhir_kirim_wa', date('Y-m-d H:i:s'));
        (get_post_meta($order_id, 'reminder_time_terakhir', true)) ? update_post_meta($order_id, 'reminder_time_terakhir', date('Y-m-d H:i:s')) : add_post_meta($order_id, 'reminder_time_terakhir', date('Y-m-d H:i:s'));

		
        if(get_option(PLUGIN_PREFIX."_license_type") == "android"){
            nwa_sendapi_cs_rotator($tipe, $order_id);	
        }else {
            nwa_curl_post($data_api, $order_id);
        }
    }
}

function nwa_sendapi_seller_notification($order_id = '', $tipe = 'after_checkout', $dt = '', $id=''){
    if ($tipe == 'order_complete') {
        $tipe2 = 'completed';
    } elseif ($tipe == 'cancel_order') {   
        $tipe2 = 'cancelled';
    } elseif ($tipe == 'order_process') {
        $tipe2 = 'processing';
    } elseif ($tipe == 'order_refund') {
        $tipe2 = 'refunded';
    } elseif ($tipe == 'order_failed') {
        $tipe2 = 'failed';
    } elseif ($tipe == 'pending_payment') {
        $tipe2 = 'pending';
    } elseif ($tipe == 'after_checkout') {
        $tipe2 = 'after_checkout';
    } elseif ($tipe == 'on_hold') {
        $tipe2 = 'on_hold';
    }elseif ($tipe == 'reminder_order') {
        $tipe2 = 'reminder_order';
    }

    if ($tipe == 'custom_form') {
        $billing_country = $dt['billing_code'];
        
        if (get_option(PLUGIN_PREFIX.'_pesan_cf_seller_notification'.$id) != '') {
            $noseller = get_option(PLUGIN_PREFIX.'_number_cf_seller_notification'.$id);
            $isi = $dt['isi_seller'];
            nwa_send_api_seller($tipe, $dt, $order_id, $isi, $billing_country, $noseller);
        }
    }else{
        $array_seller = get_option(PLUGIN_PREFIX.'_seller_service_data');
        $array_seller = json_decode($array_seller);
        foreach ($array_seller as $key => $v) {
            $selected = explode(',', $v['select']);
            $noseller = $v['wa_number'];
            if (in_array($tipe2, $selected)) { 
                $form = nwa_form($order_id, 'seller_notification'.$tipe2);
                extract($form);
                $billing_country = $dt['billing_code'];
                if (get_option(PLUGIN_PREFIX.'_toggle_seller_notification'.$tipe2) != '') {
                    if (get_option(PLUGIN_PREFIX.'_toggle_seller_list'.$key) != '') {
                        nwa_send_api_seller($tipe2, $dt, $order_id, $isi, $billing_country, $noseller);
                    }
                }
            }
        }
    }
}

function nwa_send_api_seller($tipe, $data_seller = '', $order_id = '', $isi_seller, $billing_country, $noseller){
    if ($noseller != '') {
        $noseller = nwa_validasi_nomor($noseller, $billing_country);
        if (!empty(get_option(PLUGIN_PREFIX.'_check_image_seller_notification'.$tipe))) {
            if (!empty(get_option(PLUGIN_PREFIX.'_image_seller_notification'.$tipe))) {
                $data_seller['file'] = get_option(PLUGIN_PREFIX.'_image_seller_notification'.$tipe);
            }
        } else {
            $data_seller['file'] = '';
        }
        
        $data_seller['seller_text'] = $isi_seller;
        $data_seller['no_wa_tujuan'] = $noseller;
        $data_seller['tipe'] = 'seller_custom_form';

        return nwa_curl_post($data_seller, $order_id);
    }
}

function nwa_sendapi_cs_rotator($tipe, $order_id){
    (get_post_meta($order_id, 'kirim_wa_ke', true)) ? NULL : update_post_meta($order_id, 'kirim_wa_ke', 0);
    (get_post_meta($order_id, 'cs_rotator', true)) ? update_post_meta($order_id, 'cs_rotator', 'belum') : add_post_meta($order_id, 'cs_rotator', 'belum');
    (get_post_meta($order_id, 'terakhir_kirim_wa', true)) ? update_post_meta($order_id, 'terakhir_kirim_wa', date('Y-m-d H:i:s')) : add_post_meta($order_id, 'terakhir_kirim_wa', date('Y-m-d H:i:s'));
    (get_post_meta($order_id, 'reminder_time_terakhir', true)) ? update_post_meta($order_id, 'reminder_time_terakhir', date('Y-m-d H:i:s')) : add_post_meta($order_id, 'reminder_time_terakhir', date('Y-m-d H:i:s'));

    (get_post_meta($order_id, 'nwa_apk_order', true)) ? NULL : add_post_meta($order_id, 'nwa_apk_order', 'kosong');

    if ($tipe != 'abandoned_cart') {
        $form = nwa_form($order_id,$tipe);
        extract($form);
    }

    $kirim='ok';

    // if(get_option(PLUGIN_PREFIX."_toggle_cs_rotator") != '') {
    //     echo 1;
    //     $kirim='ok';
    // }else {
    //     echo 2;
        // nwa_writelog("#$order_id - $tipe is off : Not send message to $no_wa_tujuan");
    // }

    if ($kirim=='ok') {
        $datacs = get_option(PLUGIN_PREFIX.'_customer_service_data');
        $dt_cs = json_decode($datacs,1);
        $jmlh = count($dt_cs);

        if ( get_option(PLUGIN_PREFIX.'_current_cs_rotator') != true ) { add_option(PLUGIN_PREFIX.'_current_cs_rotator',1);}

        if (get_option(PLUGIN_PREFIX.'_current_cs_rotator') > $jmlh) {
            update_option(PLUGIN_PREFIX.'_current_cs_rotator', 1);
            nwa_writelog(__('List CS now start from 1', 'notifier-for-phone'));
        }

        $dt_cs = array_values($dt_cs);
        foreach ($dt_cs as $k_cs => $v_cs){
            $current_cs_rotator = get_option(PLUGIN_PREFIX.'_current_cs_rotator');
            $cs_id = $k_cs+1;
            $wa_cs = $no_wa_tujuan;
            $player_id = $v_cs['player_id'];

            if ($current_cs_rotator == $cs_id) {
                if (!empty(get_option(PLUGIN_PREFIX.'_toggle_customer_service'.$current_cs_rotator))){
                    if (get_post_meta($order_id, 'cs_rotator', true) == 'belum' ) {
                        nwa_send_api_cs($data_api, $order_id, $isi, $billing_country, $wa_cs, $player_id, $v_cs['name']);
                        update_post_meta($order_id, 'cs_rotator', 'sudah');
                    }
                }else {
                    $next_cs_rotator = $current_cs_rotator+1;
                    update_option(PLUGIN_PREFIX.'_current_cs_rotator', $next_cs_rotator);
                    if ($next_cs_rotator > $jmlh) {
                        update_option(PLUGIN_PREFIX.'_current_cs_rotator', 1);
                        $next_cs_rotator = get_option(PLUGIN_PREFIX.'_current_cs_rotator');

                        if ($next_cs_rotator == $cs_id){
                            if (!empty(get_option(PLUGIN_PREFIX.'_toggle_customer_service'.$next_cs_rotator))) {
                                if (get_post_meta($order_id, 'cs_rotator', true) == 'belum' ) {
                                    nwa_send_api_cs($data_api, $order_id, $isi, $billing_country, $wa_cs, $player_id, $v_cs['name']);
                                    update_post_meta($order_id, 'cs_rotator', 'sudah');
                                }
                            }else {
                                $last_cs_rotator = $next_cs_rotator+1;
                                update_option(PLUGIN_PREFIX.'_current_cs_rotator', $last_cs_rotator);
                            }
                        }
                    }
                }
            }
        }
    }
}

function nwa_send_api_cs($data_api, $order_id, $isi_cs, $billing_country, $nocs, $player_id, $namacs = ''){
    $current_cs_rotator=get_option(PLUGIN_PREFIX.'_current_cs_rotator');
    $data_cs = $data_api;
    if ($nocs != '') {
        if (!empty(get_option(PLUGIN_PREFIX.'_check_image_cs_rotator'))) {
            if (!empty(get_option(PLUGIN_PREFIX.'_image_cs_rotator'))) {
                $data_cs['file'] = get_option(PLUGIN_PREFIX.'_image_cs_rotator');
            }
        } else {
            $data_cs['file'] = '';
        }
        
        $nocs = nwa_validasi_nomor($nocs, $billing_country);
        $data_cs['no_wa_tujuan'] = $nocs;
        
        $isi_cs;
        $data_cs['text'] = $isi_cs;
        $data_cs['player_id'] = $player_id;
        if (get_post_meta($order_id, 'nwa_apk_order', TRUE) == 'kosong') {
            $next_cs_rotator = $current_cs_rotator+1;
            update_option(PLUGIN_PREFIX.'_current_cs_rotator', $next_cs_rotator);
            update_post_meta($order_id, 'nwa_apk_order', $player_id);
        }

        return nwa_curl_post($data_cs, $order_id);
    }
}

function nwa_validasi_nomor($billing_phone, $billing_country =''){
    $m=new Main();
    $no_wa_tujuan=$m->phone_validation($billing_phone, $billing_country);
    return $no_wa_tujuan;
}

function nwa_curl_post($data, $order_id = ''){
    if(get_option(PLUGIN_PREFIX.'_license_type') == 'multivendor') {
        if(get_option(PLUGIN_PREFIX.'_toggle_wassenger') == 'checked') {
            nwa_send_message_wassenger($data, $order_id);
        }else if(get_option(PLUGIN_PREFIX.'_toggle_chat_api') == 'checked'){
            nwa_send_message_chatapi($data, $order_id);
        }else if(get_option(PLUGIN_PREFIX.'_toggle_wa_blas') == 'checked'){
            nwa_send_message_wa_blas($data, $order_id);
        }else if(get_option(PLUGIN_PREFIX.'_toggle_apiwha') == 'checked'){
            nwa_send_message_apiwha($data, $order_id);
        }else if(get_option(PLUGIN_PREFIX.'_toggle_waboxapp') == 'checked'){
            nwa_send_message_waboxapp($data, $order_id);
        }else if(get_option(PLUGIN_PREFIX.'_toggle_wanotif') == 'checked'){
            nwa_send_message_wanotif($data, $order_id);
        }    
    }else if (get_option(PLUGIN_PREFIX.'_license_type') == 'android') {
        nwa_curl_apk($data, $order_id);
    }else if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm') {
        nwa_curl_crm($data, $order_id);
    }else if (get_option(PLUGIN_PREFIX.'_license_type') == 'multics') {
        nwa_curl_multics($data, $order_id);
    }else {
        nwa_curl_web($data, $order_id);
    }
}

function nwa_curl_apk($data, $order_id){
    $dataplayer = get_option(PLUGIN_PREFIX.'_customer_service_data');
    $dataplayer = json_decode($dataplayer, 1);
    
    $judul = str_replace('_', ' ', $data['tipe']);
    $orderID = "ORDER ID - $order_id";
    
    $judul = ucwords($judul);
    $content = array(
        'en' => $orderID
    );

    $text = str_replace('&', 'n', $data['text']);
    $text   = spin_text($text);

    ($order_id == 'abandoned_cart') ? $device_id = $data['player_id'] : $device_id = get_post_meta($order_id, 'nwa_apk_order', true);
    
    if ($order_id == 'custom_form' && empty($data['player_id'])) {
        $device_id = get_option(PLUGIN_PREFIX.'_save_default_device');
    }else {
        $device_id = $data['player_id'];
    }

    foreach ($dataplayer as $key => $value) {
        $playerID = trim($value['player_id']);
        
        if (trim($device_id) == $playerID) {
            $data['no_wa_tujuan']=nwa_validasi_nomor($data['no_wa_tujuan'], '');
            if (strlen($device_id) == 36) {
                $fields = array(
                    'app_id' => OS_APP_ID,
                    'include_player_ids' => ["$playerID"],
                    'data' => array('type' => $judul, 'message' => $text, 'no_wa' => $data['no_wa_tujuan']),
                    'contents' => $content,
                    'headings' => array(
                        'en' => $judul,
                    ),
                );
                
                $fields = json_encode($fields);
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, OS_URL);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
                'Authorization: Basic '.OS_AUTH, ));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HEADER, false);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
                $response = curl_exec($ch);
                curl_close($ch);
                nwa_writelog("#".$order_id.__(" Order ID - Send ", "notifier-for-phone").$judul.__(' Message to ', 'notifier-for-phone').$data['no_wa_tujuan']);
            }else {
                $playerID = trim($value['player_id']);
                $param = array(
                    'data' => array(
                        "message"   => $text,
                        //, "schedule" => '2020-05-13 11:21:15',
                        "number"     => $data['no_wa_tujuan']
                    ),
                    'to' => $playerID
                );
                
                $data_json = json_encode($param);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt( $ch,CURLOPT_POST, true );
                curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
                curl_setopt( $ch,CURLOPT_POSTFIELDS, $data_json);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Authorization: Bearer AIzaSyCyXH1aC4rWgMQhaJuQLUTDXfWRBgrCZF4')); //os_auth don't change
                $response = curl_exec($ch);
                curl_close($ch);
                
                nwa_writelog("#".$order_id.__(" Order ID - Send ", "notifier-for-phone").$judul.__(' Message to ', 'notifier-for-phone').$data['no_wa_tujuan']);
            }
        }
    }
}

function nwa_curl_web($data, $order_id){
    $file  = $data['file'];
    $no_wa = $data['no_wa_tujuan'];
    $ip    = get_option(PLUGIN_PREFIX.'_ip');
    $key   = get_option(PLUGIN_PREFIX.'_api_key');
    $tipe  = strtoupper($data['tipe']);
    $tipe  = str_replace("_", " ", $tipe);

    $no_wa = str_replace("+","",$no_wa);
    $no_wa = '+'.$no_wa;

    $text = stripslashes($data['text']);
    $text = str_replace("\'", "'", $text);

    if (strpos($tipe, 'SELLER') !== false) {
        $text = stripslashes($data['seller_text']);
        $text = str_replace("\'", "'", $text);
    }

    $text   = spin_text($text);

    $data = array("phone_no" => $no_wa, "message" => $text, "key" => $key);

    $data_string = json_encode($data);
    $url = 'http://116.203.92.59/api/async_send_message';

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST"); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_VERBOSE, 0);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
    curl_setopt($ch, CURLOPT_TIMEOUT, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Content-Length: ' . strlen($data_string)) 
    );                                                                                            
    $result = curl_exec($ch);
    curl_close($ch);
    if (!empty($file)) {
        nwa_send_image($no_wa, $file);
    }

    nwa_writelog($tipe .' #'. $order_id.' '.__('- Send Message to ', 'notifier-for-phone').''.$no_wa."( $result )");
    
}

function nwa_send_image($no_wa, $file){
    $ip = get_option(PLUGIN_PREFIX.'_ip');
    $key = get_option(PLUGIN_PREFIX.'_api_key');
        
    if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm') {
        $key = get_option(PLUGIN_PREFIX.'_token_crm');
    }
    
    if (get_option(PLUGIN_PREFIX.'_license_type') == 'multics') {
        if(strpos($file, 'https:') === true){
            $file2     = $file;
        }else {
            $file2    = str_replace('http:', 'https:', $file);
        }
        // text send by multics api send message
        $text     = '';
        $url='https://multics.woo-wa.com/api/srv1/send-media-url';
        $data = array(
            "number"      => $no_wa,
            "message"     => $text,
            "media_url"   => $file2,
            "type"        => 'image'
        );
        $data_string = json_encode($data, 1);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_VERBOSE, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'device-key: '.$key,
            'Content-Type: application/json'
        ));

        $result = curl_exec($ch);

        curl_close($ch);

        $resArr = json_decode($result, 1);
        if (strpos($result, "403 Forbidden")!==false) {
            nwa_writelog(__("Key Invalid. Please deactive then activate the plugin to get latest key from server.", "notifier-for-phone"));
            $result = __("Key Invalid", "notifier-for-phone");
        }

    }else if(get_option(PLUGIN_PREFIX.'_license_type') == 'crm'){
        
    }else {
        $data = array(
            "phone_no" => $no_wa,
            "key" => $key,
            "url" => $file
        );
        
        $data_string = json_encode($data);

        $url='http://116.203.92.59/api/async_send_image_url';
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST"); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_VERBOSE, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string)) 
        ); 
        
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($response == 'image_not_found 404') {
            nwa_writelog(__('Your image was not found when sending a message to', 'notifier-for-phone').$no_wa);
        }
        
        if ($err) {
            nwa_writelog(__('Your image is failed send to ', 'notifier-for-phone').$no_wa);
        }
    }
}

function nwa_curl_crm($data, $order_id){
    $text           = $data['text'];
    $crm_token      = get_option(PLUGIN_PREFIX.'_token_crm');
    $no_wa          = $data['no_wa_tujuan'];
    $tipe           = strtoupper($data['tipe']);
    $tipe           = str_replace("_", " ", $tipe);

    $no_wa = str_replace("+","",$no_wa);

    $text = stripslashes($data['text']);
    $text = str_replace("\'", "'", $text);

    $text   = spin_text($text);

    $curl = curl_init();
    curl_setopt_array($curl, array(
    CURLOPT_URL => "https://crm.woo-wa.com/send/message-text",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => "deviceId=$crm_token&number=$no_wa&message=$text",
    CURLOPT_HTTPHEADER => array(
        "cache-control: no-cache",
        "content-type: application/x-www-form-urlencoded",
        "postman-token: 39abf704-c4dd-ac32-b548-b456f5dc55e7"
    ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    $arr = json_decode($response, 1);
	$response = $arr['message'];
	$token = substr($crm_token, -8, 8);
	$token = '********'.$token;
	if (strpos($type, "SELLER") !== false) {
		nwa_writelog('( '.__('SELLER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to', 'notifier-for-phone').' '.$no_wa.__('send by', 'notifier-for-phone')." $token ( $response )");
	}else {
		nwa_writelog('( '.__('CUSTOMER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to', 'notifier-for-phone').' '.$no_wa.__('send by', 'notifier-for-phone')." $token ( $response )");
	}
}

function nwa_curl_multics($data, $order_id){
    $key = get_option(PLUGIN_PREFIX.'_api_key');
    $file           = $data['file'];
    $text           = $data['text'];
    $no_wa          = $data['no_wa_tujuan'];
    $tipe           = strtoupper($data['tipe']);
    $tipe           = str_replace("_", " ", $tipe);

    $no_wa = str_replace("+","",$no_wa);

    $text = stripslashes($data['text']);
    $text = str_replace("\'", "'", $text);

    $text   = spin_text($text);

    $url='https://multics.woo-wa.com/api/srv1/send-text';
    $data = array(
        "number"  => $no_wa,
        "message" => $text
    );
    $data_string = json_encode($data);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_VERBOSE, 0);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
    curl_setopt($ch, CURLOPT_TIMEOUT, 360);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'device-key: '.$key,
        'Content-Type: application/json'
    ));

    $result = curl_exec($ch);
    curl_close($ch);

    $arr = json_decode($result, 1);
	$response = $arr['message'];
	$token = substr($key, -8, 8);
	$token = '********'.$token;
    if (!empty($file)) {
        nwa_send_image($no_wa, $file);
    }
	if (strpos($type, "SELLER") !== false) {
		nwa_writelog('( '.__('SELLER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to', 'notifier-for-phone').' '.$no_wa.__('send by', 'notifier-for-phone')." $token ( ". $arr["message"] ." )");
	}else {
		nwa_writelog('( '.__('CUSTOMER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to', 'notifier-for-phone').' '.$no_wa.__('send by', 'notifier-for-phone')." $token ( ". $arr["message"] ." )");
	}
}


function nwa_api_wa(){
    $data['wa_number'] = $data['no_wa_tujuan'];

    $url = 'http://api.qweasd123.com/v2.0/send-message';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) {
        // echo "cURL Error #:" . $err;
    }
}

function nwa_writelog_dev($n){
    if (DEBUG) {
        $fp = fopen(__DIR__.'/../error/dev.log', 'a');
        fwrite($fp, date('y/m/d h:i:s').' :: '.$n."\n");
        fclose($fp);
    }
}

function nwa_writelog($n){
    $timezone = get_option('timezone_string');
    if (empty($timezone) or $timezone == '') {
        // $timezone="Asia/Jakarta";
    } else {
        date_default_timezone_set($timezone);
    }
    $fp = fopen(__DIR__.'/../error/error.log', 'a');
    $notallow = array('select ', 'insert ', 'replace ', 'order by', 'group by', 'update ', '{', 'http');
    $tulis = 0;
    foreach ($notallow as $k) {
        if (strpos(strtolower($n), 'select') !== false) {
        } else {
            $tulis = 1;
        }
    }
    if ($tulis == 1) {
        if (empty($timezone)) {
            $gmt = get_option('gmt_offset');
            $date = gmdate("d-m-Y H:i:s", time() + 3600*($gmt+date("I")));
            fwrite($fp, $date.' :: '.$n."\n");
        }else {
            fwrite($fp, date('d-m-Y H:i:s').' :: '.$n."\n");
        }
    }
    fclose($fp);
}

function nwa_isJson($string){
    json_decode($string);

    return json_last_error() == JSON_ERROR_NONE;
}

function nwa_prepre($array){
    $result = '<pre>'.print_r($array, 1).'</pre>';

    echo $result;
}

// Adding Meta container admin shop_order pages
add_action( 'add_meta_boxes', 'nwa_add_meta_boxes' );
if ( ! function_exists( 'nwa_add_meta_boxes' ) )
{
    function nwa_add_meta_boxes()
    {
        add_meta_box( 'nwa_meta_data', __(PLUGIN_PREFIX .' Additional Info','woocommerce'), 'nwa_data_meta_box', 'shop_order', 'side', 'core' );
    }
}

// Adding Meta field in the meta container admin shop_order pages
if ( ! function_exists( 'nwa_data_meta_box' ) ){
    function nwa_data_meta_box(){
        global $post;

        $meta_field_data = get_post_meta( $post->ID, 'nwa_meta_box_slug', true ) ? get_post_meta( $post->ID, 'nwa_meta_box_slug', true ) : '';

        echo '<input type="hidden" name="nwa_metabox_nonce" value="' . wp_create_nonce() . '">
        <p style="border-bottom:solid 1px #eee;padding-bottom:13px;">
            <textarea type="text" style="width:250px; height:150px;";" name="nwa_field_name">' . $meta_field_data . '</textarea></p>
            <button style="margin-left:200px;" type="submit" class="button button-primary" name="save" value="Save">'.__( 'Save', 'nwa_meta_box_slug' ).'</button>';

    }
}

// Save the data of the Meta field
add_action( 'save_post', 'nwa_save_data_metabox', 10, 1 );
if ( ! function_exists( 'nwa_save_data_metabox' ) )
{
    function nwa_save_data_metabox( $post_id ) {
        // We need to verify this with the proper authorization (security stuff).
        // Check if our nonce is set.
        if ( ! isset( $_POST[ 'nwa_metabox_nonce' ] ) ) {
            return $post_id;
        }
        $nonce = $_REQUEST[ 'nwa_metabox_nonce' ];
        //Verify that the nonce is valid.
        if ( ! wp_verify_nonce( $nonce ) ) {
            return $post_id;
        }
        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return $post_id;
        }
        // Check the user's permissions.
        if ( 'page' == $_POST[ 'post_type' ] ) {
            if ( ! current_user_can( 'edit_page', $post_id ) ) {
                return $post_id;
            }
        } else {
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return $post_id;
            }
        }
        // --- Its safe for us to save the data ! --- //
        // Sanitize user input  and update the meta field in the database.
        update_post_meta( $post_id, 'nwa_meta_box_slug', $_POST[ 'nwa_field_name' ] );
    }
}

// Add the field to the product
// add_action('woocommerce_before_add_to_cart_button', 'nwa_custom_product_field');
function nwa_custom_product_field() {
    echo '<div id="nwa_custom_field">
        <label>' .PLUGIN_PREFIX. __( ' Additional Info') . ' </label>
        <input type="text" name="nwa_field_name" value="">
    </div><br>';
}

// Store custom field
add_filter( 'woocommerce_add_cart_item_data', 'save_nwa_custom_product_field', 10, 2 );
function save_nwa_custom_product_field( $cart_item_data, $product_id ) {
    if( isset( $_REQUEST['nwa_field_name'] ) ) {
        $cart_item_data[ 'nwa_field_name' ] = $_REQUEST['nwa_field_name'];
        // below statement make sure every add to cart action as unique line item
        $cart_item_data['unique_key'] = md5( microtime().rand() );
        WC()->session->set( 'nwa_order_data', $_REQUEST['nwa_field_name'] );
    }
    return $cart_item_data;
}

// Add a hidden field with the correct value to the checkout
add_action( 'woocommerce_after_order_notes', 'nwa_custom_checkout_field' );
function nwa_custom_checkout_field( $checkout ) {
    $value = WC()->session->get( 'nwa_order_data' );
    echo '<div id="nwa_custom_checkout_field">
            <input type="hidden" class="input-hidden" name="nwa_field_name" id="nwa_field_name" value="' . $value . '">
    </div>';
}

// Save the order meta with hidden field value
add_action( 'woocommerce_checkout_update_order_meta', 'nwa_custom_checkout_field_update_order_meta' );
function nwa_custom_checkout_field_update_order_meta( $order_id ) {
    if ( ! empty( $_POST['nwa_field_name'] ) ) {
        update_post_meta( $order_id, 'nwa_meta_box_slug', $_POST['nwa_field_name'] );
    }
}

// Display field value on the order edit page (not in custom fields metabox)
add_action( 'woocommerce_admin_order_data_after_billing_address', 'nwa_custom_checkout_field_display_admin_order_meta', 10, 1 );
function nwa_custom_checkout_field_display_admin_order_meta($order){
    $nwa_custom_field = get_post_meta( $order->get_id(), 'nwa_meta_box_slug', true );
    if ( ! empty( $nwa_custom_field ) ) {
        echo '<p><strong>'. PLUGIN_PREFIX.__(" Additional Info", "woocommerce").':</strong> ' . get_post_meta( $order->get_id(), 'nwa_meta_box_slug', true ) . '</p>';
    }
}

// Render meta on cart and checkout
add_filter( 'woocommerce_get_item_data', 'nwa_render_meta_on_cart_and_checkout', 10, 2 );
function nwa_render_meta_on_cart_and_checkout( $cart_data, $cart_item = null ) {
    $custom_items = array();
    if( !empty( $cart_data ) ) $custom_items = $cart_data;

    if( isset( $cart_item['nwa_field_name'] ) )
        $custom_items[] = array( "name" => 'Additional Info', "value" => $cart_item['nwa_field_name'] );

    return $custom_items;
}

// Add the information as meta data so that it can be seen as part of the order
add_action('woocommerce_add_order_item_meta','nwa_add_values_to_order_item_meta', 10, 3 );
function nwa_add_values_to_order_item_meta( $item_id, $cart_item, $cart_item_key ) {
    // lets add the meta data to the order (with a label as key slug)
    if( ! empty( $cart_item['nwa_field_name'] ) )
        wc_add_order_item_meta($item_id, PLUGIN_PREFIX.__(' Additional Info label'), $cart_item['nwa_field_name'], true);
}


function nwa_option_exists($name, $site_wide=false){
    global $wpdb; return $wpdb->query("SELECT * FROM ". ($site_wide ? $wpdb->base_prefix : $wpdb->prefix). "options WHERE option_name ='$name' LIMIT 1");
}