<?php

class Main{

    public function send_message($data){
        if (get_option(PLUGIN_PREFIX.'_license_type') == 'android') {
            $response = $this->send_message_android($data);
        }else if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm') {
            $response = $this->send_message_crm($data);
        }else if(get_option(PLUGIN_PREFIX.'_license_type') == 'multics'){
            $response = $this->send_message_multics($data);
        }else {
            $response = $this->send_message_website($data);
        }

        return $response;
    }
    
    public function nwa_get_spin($text){
        $text = htmlspecialchars(strip_tags(trim($text)));
        $arr = explode('|', $text);
        $index = rand(0, count($arr) -1);
        $output = $arr[$index];
        
        return $output;
    }

    public function spin_text($text) {
        preg_match_all("/\[([^\]]*)\]/", $text, $matches);
        $matches_replace = array_map(array($this, 'nwa_get_spin'), $matches[1]);
        
        $output = str_replace($matches[0], $matches_replace, $text);
        return $output;
    }

    public function send_message_website($data){
        $data_api = $data['data_api'];
        
        $ip       = $data_api['ip'];
        $key      = $data_api['key'];
        $text     = $data_api['text'];
        $text     = $this->spin_text($text);
        
        $type     = $data_api['type'];
        $order_id = $data_api['order_id'];
        $no_wa    = $data_api['no_wa_tujuan'];

        

        $type     = str_replace('_', ' ', $type);
        $type     = strtoupper($type);

        // value 1 seller, value 2 customer
        (strpos($type, 'SELLER') !== false) ? $no_wa = $data['no_wa_tujuan'] : $no_wa = $data_api['no_wa_tujuan'];
        
        // $no_wa = $this->phone_validation($no_wa,'');
        $data_api    = array("phone_no" => $no_wa, "message" => $text, "key" => $key);
        $data_string = json_encode($data_api);
        $url = 'http://116.203.191.58/api/async_send_message';
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST"); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_VERBOSE, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string)) 
        );                                                                                            
        $result = curl_exec($ch);
        curl_close($ch);


        $data['log'] = '';
        if (strpos($result, "403 Forbidden")!==false) {
            nwa_writelog(__("Key Invalid. Please deactive then activate the plugin to get latest key from server.", "notifier-for-phone"));
            $result = __("Key Invalid", "notifier-for-phone");
        }
        $key = substr($key, -8, 8);
        $key = '********'.$key;

        if (strpos($type, "SELLER") !== false) {
            $data['log'] = '( '.__('SELLER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to ').$no_wa.__(' send by ', 'notifier-for-phone')."$key ( $result )";
        }else {
            $data['log'] = '( '.__('CUSTOMER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to ', 'notifier-for-phone').$no_wa.__(' send by ', 'notifier-for-phone')."$key ( $result )";
        }

        return $data;
    }

    public function send_message_multics($data){
        $data_api = $data['data_api'];
        
        $ip       = $data_api['ip'];
        $key      = $data_api['key'];
        $text     = $data_api['text'];
        $text     = $this->spin_text($text);
        
        $type     = $data_api['type'];
        $order_id = $data_api['order_id'];
        $no_wa    = $data_api['no_wa_tujuan'];

        $type     = str_replace('_', ' ', $type);
        $type     = strtoupper($type);

        // value 1 seller, value 2 customer
        (strpos($type, 'SELLER') !== false) ? $no_wa = $data['no_wa_tujuan'] : $no_wa = $data_api['no_wa_tujuan'];
        
        // $no_wa = $this->phone_validation($no_wa,'');

        $url='https://multics.woo-wa.com/api/srv1/send-text';
        $data = array(
            "number"  => $no_wa,
            "message" => $text
        );
        $data_string = json_encode($data);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_VERBOSE, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'device-key: '.$key,
            'Content-Type: application/json'
        ));

        $result = curl_exec($ch);
        curl_close($ch);

        $data['log'] = '';
        if (strpos($result, "403 Forbidden")!==false) {
            nwa_writelog(__("Key Invalid. Please deactive then activate the plugin to get latest key from server.", "notifier-for-phone"));
            $result = __("Key Invalid", "notifier-for-phone");
        }
        $key = substr($key, -8, 8);
        $key = '********'.$key;

        if (strpos($type, "SELLER") !== false) {
            $data['log'] = '( '.__('SELLER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to ').$no_wa.__(' send by ', 'notifier-for-phone')."$key ( $result )";
        }else {
            $data['log'] = '( '.__('CUSTOMER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to ', 'notifier-for-phone').$no_wa.__(' send by ', 'notifier-for-phone')."$key ( $result )";
        }

        return $data;
    }

    public function send_image($data){
        
        $data_api = $data['data_api'];
        
        $ip       = $data_api['ip'];
        $key      = $data_api['key'];
        $file     = $data_api['file'];
        $order_id = $data_api['order_id'];
        $no_wa    = $data_api['no_wa_tujuan'];
        
        $type     = $data_api['type'];
        $type     = str_replace('_', ' ', $type);
        $type     = strtoupper($type);

        
        if(strpos($file, 'https:') === true){
            $file2     = $data_api['file'];
        }else {
            $file2    = str_replace('http:', 'https:', $file);
        }
        
        // value 1 seller, value 2 customer
        (strpos($type, 'SELLER') !== false) ? $no_wa = $data['no_wa_tujuan'] : $no_wa = $data_api['no_wa_tujuan'];

        $no_wa = str_replace("+","",$no_wa);
        $no_wa = '+'.$no_wa;

        if (get_option(PLUGIN_PREFIX.'_license_type') == 'multics') {
            // text send by multics api send message
            $text     = '';
            $url='https://multics.woo-wa.com/api/srv1/send-media-url';
            $data = array(
                "number"      => $no_wa,
                "message"     => $text,
                "media_url"   => $file2,
                "type"        => 'image'
            );
            $data_string = json_encode($data, 1);

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_VERBOSE, 0);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 360);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'device-key: '.$key,
                'Content-Type: application/json'
            ));

            $result = curl_exec($ch);

            curl_close($ch);

            $resArr = json_decode($result, 1);

            if (strpos($result, "403 Forbidden")!==false) {
                nwa_writelog(__("Key Invalid. Please deactive then activate the plugin to get latest key from server.", "notifier-for-phone"));
                $result = __("Key Invalid", "notifier-for-phone");
            }
            $key = substr($key, -8, 8);
            $key = '********'.$key;

            if (strpos($type, "SELLER") !== false) {
                $data['log'] = '( '.__('SELLER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to ').$no_wa.__(' send by ', 'notifier-for-phone')."$key ( ". $resArr["message"] . " )";
            }else {
                $data['log'] = '( '.__('CUSTOMER', 'notifier-for-phone').' ) '.$type.' #'.$order_id.' - '.__('Send Message to ', 'notifier-for-phone').$no_wa.__(' send by ', 'notifier-for-phone')."$key ( ". $resArr["message"] . " )";
            }
    
        }else {
            $data_file = array(
                "phone_no" => $no_wa,
                "key" => $key,
                "url" => $file
            );
            
            $data_string = json_encode($data_file);
            $url='http://116.203.191.58/api/async_send_image_url';
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST"); 
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_VERBOSE, 0);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 360);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($data_string)) 
            ); 
            
            $response = curl_exec($ch);
            $err = curl_error($ch);
            curl_close($ch);
    
            if ($response == 'image_not_found 404') {
                $data['log'] = 'Your image was not found when sending a message to'.$no_wa;
            }else {
                $data['log'] = $response;
            }
    
        }
        
        return $data['log'];
    }

    public function send_schedule_message($data){
        if (get_option(PLUGIN_PREFIX.'_license_type') == ('android')) {
            if (strlen($data['player_id']) > 36) {
                $time      = $data['order_complete_followup'];
                $text      = $data['text'];
                $file      = $data['file'];
                $type      = $data['type'];
                $order_id  = $data['order_id'];
                $player_id = $data['player_id'];
                $no_wa     = $data['no_wa_tujuan'];
                
                $playerID  = trim($value['player_id']);
                
                if ($playerID == '' || empty($playerID)) {
                    $playerID = get_option(PLUGIN_PREFIX.'_save_default_device');
                }
                
                $param = [
                    "to" => "$playerID",
                    "data" => [
                        "number" => "$no_wa",
                        "schedule"   => "$time",
                        "message" => "$text"
                        ]
                    ];
                    
                $data_json = json_encode($param);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt( $ch,CURLOPT_POST, true );
                curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
                curl_setopt( $ch,CURLOPT_POSTFIELDS, $data_json);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Authorization: Bearer AIzaSyCyXH1aC4rWgMQhaJuQLUTDXfWRBgrCZF4')); //os_auth don't change
                $response = curl_exec($ch);
                curl_close($ch);
                
                $log = '( CUSTOMER ) '.$type.' #'.$order_id.' - Set Schedule at '.$time.' for '.$no_wa."( $response )";
            }else {
                $data_api = $data['data_api'];
                
                $ip       = $data_api['ip'];
                $key      = $data_api['key'];
                $text     = $data_api['text'];
                $type     = $data_api['type'];
                $order_id = $data_api['order_id'];
                $no_wa    = $data_api['no_wa_tujuan'];
                $time     = $data_api['order_complete_followup'];
                
                $type     = str_replace('_', ' ', $type);
                $type     = strtoupper($type);
                
                $timezone = get_option('timezone_string');
                $time_sch     = $data_api['order_complete_followup'];
                if ($timezone != 'Asia/Jakarta') {
                    $date = new \DateTime($time, new DateTimeZone($timezone));
                    $date->setTimezone(new DateTimeZone('Asia/Jakarta'));
                    $time_sch = $date->format('Y-m-d H:i');
                }
    
    
                $url='http://116.203.191.58/api/scheduler';
                $data_curl = array(
                    "phone_no" => $no_wa,
                    "key"      => $key,
                    "sch_date" => $time_sch,
                    "api_type" => 'text', // (text, image_text, image, file)
                    "message"  => $text,
                );
        
                $data_string = json_encode($data_curl);
                
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_VERBOSE, 0);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
                curl_setopt($ch, CURLOPT_TIMEOUT, 360);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($data_string))
                );
                
                $response = curl_exec($ch);
                curl_close($ch);
                
                $log = '( CUSTOMER ) '.$type.' #'.$order_id.' - Set Schedule at '.$time.' for '.$no_wa."( $response )";
                
                if ($response == 'sch_more_than_3_in_1_minute') {
                    $data_api['order_complete_followup'] = date('Y-m-d H:i', strtotime($time .'+ 1 minutes'));
                    $time     = $data_api['order_complete_followup'];
                    $data['data_api'] = $data_api;
                    $data['response'] = $response;
                    
                    $log = '( CUSTOMER ) '.$type.' #'.$order_id.' - Set Schedule at '.$time.' for '.$no_wa."( $response )";
                }
            }
        }else if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm' || get_option(PLUGIN_PREFIX.'_license_type') == 'multics') {
            $this->send_message($data);
        }

        $data['log'] = $log;

        return $data;
    }

    public function send_schedule_image($data){
        if (get_option(PLUGIN_PREFIX.'_license_type') != 'android') {
            $data_api = $data['data_api'];

            $ip       = $data_api['ip'];
            $key      = $data_api['key'];
            $type     = $data_api['type'];
            $text     = $data_api['text'];
            $img_url  = $data_api['file'];
            $order_id = $data_api['order_id'];
            $no_wa    = $data_api['no_wa_tujuan'];
            $time     = $data_api['order_complete_followup'];
            $timezone = get_option('timezone_string');
    
            $type     = str_replace('_', ' ', $type);
            $type     = strtoupper($type);

            $time_sch     = $data_api['order_complete_followup'];
            if ($timezone != 'Asia/Jakarta') {
                $date = new \DateTime($time, new DateTimeZone($timezone));
                $date->setTimezone(new DateTimeZone('Asia/Jakarta'));
                $time_sch = $date->format('Y-m-d H:i');
            }

            $url='http://116.203.191.58/api/scheduler';
            $data_curl = array(
                "phone_no" => $no_wa,
                "key"      => $key,
                "sch_date" => $time,
                "api_type" => 'image_text', // (text, image_text, image, file)
                "message"  => $text, // (text, image_text, image, file)
                "url"      => $img_url
            );
            $data_string = json_encode($data_curl);

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_VERBOSE, 0);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 360);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string))
            );
            $response = curl_exec($ch);
            curl_close($ch);

            $log = '( CUSTOMER ) '.$type.' #'.$order_id.' - Set Schedule at '.$time.' for '.$no_wa."( $response )";
            
            if ($response == 'sch_more_than_3_in_1_minute') {
                $data_api['order_complete_followup'] = date('Y-m-d H:i', strtotime($time .'+ 1 minutes'));
                $time     = $data_api['order_complete_followup'];
                $data['data_api'] = $data_api;
                $data['response'] = $response;
                
                $log = '( CUSTOMER ) '.$type.' #'.$order_id.' - Set Schedule at '.$time.' for '.$no_wa."( $response )";
            }

            $data['log'] = $log;

            return $data;
        }
    }

    public function reschedule_send_message($data){
        $data_api = $data['data_api'];
        $time     = $data_api['order_complete_followup'];

        $data['data_api']['order_complete_followup'] = date('Y-m-d H:i', strtotime($time .'+1 minutes', strtotime($time)));
        $this->send_schedule_message($data);
    }

    public function send_message_android($data){
        $data_api  = $data['data_api'];
        $text      = $data['text'];
        $file      = $data['file'];
        $type      = $data['type'];
        $order_id  = $data['order_id'];
        $player_id = $data['player_id'];
        if (empty($file)) {
            $file = '';
        }
        if (empty($player_id)) {
            $player_id = get_option(PLUGIN_PREFIX.'_save_default_device');
        }
        $no_wa     = $data['no_wa_tujuan'];
        
        $type     = $data['type'];
        $type     = str_replace('_', ' ', $type);
        $type     = strtoupper($type);

        // value 1 seller, value 2 customer
        (strpos($type, 'SELLER') !== false) ? $no_wa = $data['no_wa_tujuan'] : $no_wa = $data_api['no_wa_tujuan'];
        
        // $no_wa = $this->phone_validation($no_wa, '');
        $dataplayer = get_option(PLUGIN_PREFIX.'_customer_service_data');
        $dataplayer = json_decode($dataplayer, 1);
        
        $orderID = "ORDER ID - $order_id";
        
        $judul   = str_replace('_', ' ', $type);
        $judul   = ucwords($judul);
        $content = array(
            'en' => $orderID
        );
        
        $text = str_replace("&amp;", "n", $text);
        $text   = $this->spin_text($text);

        // ($order_id == 'custom_form' or $order_id == 'abandoned_cart') ? $typemsg = $player_id : $typemsg = get_post_meta($order_id, 'nwa_apk_order', true);
        // $typemsg = get_post_meta($order_id, 'nwa_apk_order', true);
        if (($order_id == 'abandoned_cart' or empty(get_post_meta($order_id, 'nwa_apk_order', true))) or get_post_meta($order_id, 'nwa_apk_order', true) == 'kosong') {
            $typemsg = get_option(PLUGIN_PREFIX.'_save_default_device');
        }else {
            $typemsg = get_post_meta($order_id, 'nwa_apk_order', true);
        }

        (strpos($type, "seller") === 0) ? $typemsg = get_option(PLUGIN_PREFIX.'_save_default_device') : NULL;

        foreach ($dataplayer as $key => $value) {
            $playerID  = trim($value['player_id']);
            if (trim($typemsg) == $playerID){
                if (strlen($typemsg) == 36) {
                    // $text = rawurlencode($text);
                    $fields = array(
                        'app_id' => OS_APP_ID,
                        'include_player_ids' => ["$playerID"],
                        'data' => array('type' => $judul, 'message' => $text, 'no_wa' => $data['no_wa_tujuan']),
                        'contents' => $content,
                        'headings' => array(
                            'en' => $judul,
                        ),
                    );
                    
                    $fields = json_encode($fields);
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, OS_URL);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
                    'Authorization: Basic '.OS_AUTH, ));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_HEADER, false);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
                    $response = curl_exec($ch);
                    curl_close($ch);
    
                    nwa_writelog("#".$order_id.__(" Order ID - Send ", "notifier-for-phone").$judul.__(' Message to ', 'notifier-for-phone').$data['no_wa_tujuan']);
                }else {
                    $playerID  = trim($value['player_id']);
                    $param = array(
                        'data' => array(
                            "message"   => $text,
                            "number"     => $data['no_wa_tujuan']
                        ),
                        'to' => $playerID
                    );
                    
                    $data_json = json_encode($param);
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                    curl_setopt( $ch,CURLOPT_POST, true );
                    curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
                    curl_setopt( $ch,CURLOPT_POSTFIELDS, $data_json);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json',
                        'Authorization: Bearer AIzaSyCyXH1aC4rWgMQhaJuQLUTDXfWRBgrCZF4')); //os_auth don't change
                    $response = curl_exec($ch);
                    curl_close($ch);
                    
                    nwa_writelog("#".$order_id.__(" Order ID - Send ", "notifier-for-phone").$judul.__(' Message to ', 'notifier-for-phone').$data['no_wa_tujuan']);
                }
            }
        }
    }

    public function android_validation($data){
        $data_api = $data['data_api'];

        $text     = $data_api['text'];
        $file     = $data_api['file'];
        $type     = $data_api['type'];
        $order_id = $data_api['order_id'];
        $no_wa    = $data_api['no_wa_tujuan'];

        $text = str_replace('&', 'n', $text);
        
        $kirim = 'no';
        
        if(get_option(PLUGIN_PREFIX."_toggle_cs_rotator") != '') {
            
        }
        $kirim = 'ok';
        
        if ($kirim=='ok') {
            
            $datacs = get_option(PLUGIN_PREFIX.'_customer_service_data');
            $dt_cs  = json_decode($datacs,1);
            $jmlh   = count($dt_cs);
            
            if ( get_option(PLUGIN_PREFIX.'_current_cs_rotator') != true ) { add_option(PLUGIN_PREFIX.'_current_cs_rotator',1);}
            
            if (get_option(PLUGIN_PREFIX.'_current_cs_rotator') > $jmlh) {
                
                update_option(PLUGIN_PREFIX.'_current_cs_rotator', 1);
                $this->writelog('List CS now start from 1');
            }
            
            if (strpos($type, 'seller') !== 0) {
                $dt_cs = array_values($dt_cs);
                foreach ($dt_cs as $k_cs => $v_cs){
                    $current_cs_rotator = get_option(PLUGIN_PREFIX.'_current_cs_rotator');
                    $cs_id = $k_cs+1;
                    $wa_cs = $no_wa_tujuan;
                    $player_id = $v_cs['player_id'];
                    if ($current_cs_rotator == $cs_id) {
                        if (!empty(get_option(PLUGIN_PREFIX.'_toggle_customer_service'.$current_cs_rotator))){
                            if (get_post_meta($order_id, 'cs_rotator', true) == 'belum' ) {
                                $current_cs_rotator = get_option(PLUGIN_PREFIX.'_current_cs_rotator');
                                $data_api['player_id'] = $player_id;
                                $data_api['name'] = $name;
                                update_post_meta($order_id, 'cs_rotator', 'sudah');
                                if (get_post_meta($order_id, 'nwa_apk_order', TRUE) == 'kosong') {
                                    $next_cs_rotator = $current_cs_rotator+1;
                                    update_option(PLUGIN_PREFIX.'_current_cs_rotator', $next_cs_rotator);
                                    update_post_meta($order_id, 'nwa_apk_order', $player_id);
                                }
                            }
                        }else {
                            $next_cs_rotator = $current_cs_rotator+1;
                            update_option(PLUGIN_PREFIX.'_current_cs_rotator', $next_cs_rotator);
                            if ($next_cs_rotator > $jmlh) { 
                                update_option(PLUGIN_PREFIX.'_current_cs_rotator', 1);
                                $next_cs_rotator = get_option(PLUGIN_PREFIX.'_current_cs_rotator');
                                if ($next_cs_rotator == $cs_id){
                                    if (!empty(get_option(PLUGIN_PREFIX.'_toggle_customer_service'.$next_cs_rotator))) {
                                        if (get_post_meta($order_id, 'cs_rotator', true) == 'belum' ) {
                                            $current_cs_rotator = get_option(PLUGIN_PREFIX.'_current_cs_rotator');
                                            $data_api['player_id'] = $player_id;
                                            $data_api['name'] = $name;
                                            update_post_meta($order_id, 'cs_rotator', 'sudah');
                                            if (get_post_meta($order_id, 'nwa_apk_order', TRUE) == 'kosong') {
                                                $next_cs_rotator = $current_cs_rotator+1;
                                                update_option(PLUGIN_PREFIX.'_current_cs_rotator', $next_cs_rotator);
                                                update_post_meta($order_id, 'nwa_apk_order', $player_id);
                                            }
                                        }
                                    }else {
                                        $last_cs_rotator = $next_cs_rotator+1;
                                        update_option(PLUGIN_PREFIX.'_current_cs_rotator', $last_cs_rotator);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        
        
        return $data_api;
    }

    public function send_message_crm($data){

        $data_api = $data['data_api'];
        
        $text   = $data_api['text'];
         
        $text   = $this->spin_text($text);

        $crm_token      = $data_api['key'];

        $type           = $data_api['type'];
        $order_id       = $data_api['order_id'];
        $no_wa          = $data_api['no_wa_tujuan'];

        $type     = str_replace('_', ' ', $type);
        $type     = strtoupper($type);

        // value 1 seller, value 2 customer
        (strpos($type, 'SELLER') !== false) ? $no_wa = $data['no_wa_tujuan'] : $no_wa = $data_api['no_wa_tujuan'];
        // $no_wa = $this->phone_validation($no_wa,'');
        $no_wa = str_replace('+', '', $no_wa);

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => "https://crm.woo-wa.com/send/message-text",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "deviceId=$crm_token&number=$no_wa&message=$text",
        CURLOPT_HTTPHEADER => array(
            "cache-control: no-cache",
            "content-type: application/x-www-form-urlencoded",
            "postman-token: 39abf704-c4dd-ac32-b548-b456f5dc55e7"
        ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            nwa_writelog("cURL Error #:" . json_encode($err));
        }

        $arr = json_decode($response, 1);
        $data['log'];
        $response = $arr['message'];
        $token = substr($crm_token, -8, 8);
        $token = '********'.$token;

        if (strpos($type, "SELLER") !== false) {
            $data['log'] = '( SELLER ) '.$type.' #'.$order_id.' - Send Message to '.$no_wa." send by $crm_token ( $response )";
        }else {
            $data['log'] = '( CUSTOMER ) '.$type.' #'.$order_id.' - Send Message to '.$no_wa." send by $crm_token( $response )";
        }

        return $data;
    }

    public function get_data_order($order_id, $type = 'after_checkout'){
        if (get_option(PLUGIN_PREFIX.'_license_type') == 'android') {
            if ($type != 'abandoned_cart') {
                $data = $this->order_validation($order_id, $type);
                $data = $this->android_validation($data);
            }
        }else {
            $data = $this->order_validation($order_id, $type);
        }

        return $data;
    }

    public function order_validation($order_id, $type ='after_checkout'){
        $order = wc_get_order($order_id);
        foreach ($order->get_items() as $item_key => $item_values):
            $item_id           = $item_values->get_id();
            $item_name         = $item_values->get_name();
            $item_data         = $item_values->get_data();
            $item_type         = $item_values->get_type();
            $product           = $item_values->get_product();
            $product_id        = $item_values->get_product_id();
            $product_link      = get_permalink($product_id);
            $product_links[]   = get_permalink($product_id);
            $product_instructions = $product->get_meta( '_instruction' );
            $wcfm_tracking_url = wc_get_order_item_meta($item_id, 'wcfm_tracking_url', true);
			$wcfm_tracking_code = wc_get_order_item_meta($item_id, 'wcfm_tracking_code', true);
            $line_total        = $item_data['total'];
            $quantity          = $item_data['quantity'];
            $line_subtotal     = $item_data['subtotal'];
            $line_total_tax    = $item_data['total_tax'];
            $tax_class         = $item_data['tax_class'];
            $product_id        = $item_data['product_id'];
            $line_subtotal_tax = $item_data['subtotal_tax'];
            $variation_id      = $item_data['variation_id'];
            $variation_text	   ='';
            
            if( $product->is_type('variation') ){
                $variation_attributes = $product->get_variation_attributes();
                
                foreach ($item_values->get_meta_data() as $metaData) {
                    $attribute = $metaData->get_data();
                    $value = $attribute['value'];
                    if ($value) {
                        $variation_text .= "$value, ";	
                    }
                }
                $product_variations[$item_id] = rtrim($variation_text,',');
    
                foreach ($product_variations as $key_var => $val_var) {
                    $val_var = trim($val_var,', ');
                    if ($key_var == $item_id) {
                        $Arrproduct_name[]      = $item_data['name'].' - '.$val_var.', x '.$quantity;
                    }
                }
            }else {
                $Arrproduct_name[]         = $item_data['name'].' x '.$quantity;
                $Arrproduct_name_no_qty[]  = $item_data['name'];
                $Arrproduct_name_link[]    = $item_data['name'].' x '.$quantity."\n".$product_link;
                $Arrproduct_name_link_no_qty[] = $item_data['name']."\n".$product_link;
            }
    
            if ( !empty($product_id) || $product_id != "" ) {
                $product_digital = get_post_meta($product_id);
                if (!empty($product_digital)) {
                    if ( !empty($product_digital['_downloadable_files'][0]) || $product_digital['_downloadable_files'][0] !== "" ) {
                        $downloadFileUnserialize = unserialize($product_digital['_downloadable_files'][0]);
                        
                        $linkFile = "";
            
                        $i = 0;
                        if (!empty($downloadFileUnserialize)) {
                            foreach ($downloadFileUnserialize as $k => $v) {
                                $linkFile .= $v['file'] . ", ";
                                $i++;
                            }
                        }
                        
                        $product_digital_link = substr($linkFile, 0, -2);
                    }
                }
        
            }
        
        endforeach;

        $nwa_courier = get_post_meta($order_id, 'nwa_meta_box_courier', true);
        $nwa_additional_info = get_post_meta( $order_id, 'nwa_meta_box_slug', true );
        $aftership_courier = get_post_meta($order_id, '_aftership_tracking_provider_name', true);
        $nwa_tracking_number = get_post_meta($order_id, 'nwa_meta_box_tracking_number', true);
        $aftership_tracking_number = get_post_meta($order_id, '_aftership_tracking_number', true);

        $delivery_type = get_post_meta($order_id, '_byconsolewooodtrestro_order_type', true);
    
        if ($delivery_type == 'dinein') {
            $delivery_type = 'Dine in';
        }else if($delivery_type == 'levering'){
            $delivery_type = 'Delivery';
        }else{
            $delivery_type = 'Pick up';
        }
    
        $delivery_date = get_post_meta($order_id, '_byconsolewooodtrestro_delivery_date', true);
        $delivery_time = get_post_meta($order_id, '_byconsolewooodtrestro_delivery_time', true);

        $postmetas = get_post_meta($order_id);
        foreach($postmetas as $meta_key=>$meta_value) {
            $postmeta_key[]="{"."$meta_key"."}";
            $postmeta_val[]=$meta_value[0];
            // $$meta_key = $meta_value[0];
        }

        if (!empty($Arrproduct_name_link_no_qty)) {
            $product_name_link_no_qty = implode("\n", $Arrproduct_name_link_no_qty);
        }else {
            $product_name_link_no_qty = '';
        }

        if (!empty($Arrproduct_name_link)) {
            $product_name_link = implode("\n", $Arrproduct_name_link);
        }else {
            $product_name_link = '';
        }
        
        if (!empty($product_links)) {
            $product_link = implode("\n", $product_links);
        }else {
            $product_link = '';
        }
        
        if (!empty($Arrproduct_name)) {
            $product_name = implode("\n", $Arrproduct_name);
            $product_name = str_replace("-", " ", $product_name);
        }else {
            $product_name = '';
        }
    
        
        if (!empty($Arrproduct_name_no_qty)) {
            $product_name_no_qty = implode("\n", $Arrproduct_name_no_qty);
        }else {
            $product_name_no_qty = '';
        }
        
        // $payment_url   = get_post_meta($order_id , 'Xendit_invoice_url', true );
        
        // if (empty(get_post_meta($order_id , 'Xendit_invoice_url', true ))) {
        //     $payment_url = $order->get_meta('_mt_payment_url');
        // }

        $ast_no_resi          = get_post_meta($order_id , '_wc_shipment_tracking_items', true );
		if(!empty($ast_no_resi)){
			$ast_no_resi		  = $ast_no_resi[0]['tracking_number'];	
		}

		$ast_courier          = get_post_meta($order_id , '_wc_shipment_tracking_items', true );
		if(!empty($ast_courier)){
			$ast_courier	      = $ast_courier[0]['tracking_provider'];
		}

        // $ast_link_tracking    = 'https://resi.id/s/'.$ast_no_resi;

        $shipping = $order->get_items( 'shipping' );
        $resi     = get_post_meta($order_id , '_indo_ongkir_resi', true );

        // billing form tambahan untuk brazil
        if (method_exists( $order, 'get_meta' )) {
            $billing_cpf = $order->get_meta( '_billing_cpf' );
            $billing_cnpj = $order->get_meta( '_billing_cnpj' );
            $billing_rg = $order->get_meta( '_billing_rg' );
            $billing_number = $order->get_meta( '_billing_number' );
            $billing_neighborhood = $order->get_meta( '_billing_neighborhood' );
            $billing_sex = substr( $order->get_meta( '_billing_sex' ), 0, 1 );
            $billing_ie = $order->get_meta( '_billing_ie' );

            $shipping_number = $order->get_meta( '_shipping_number' );
            $shipping_neighborhood = $order->get_meta( '_shipping_neighborhood' );
        }

        $array_recipt = [];
        $array_recipt_after = [];
        if (is_array($shipping)) {
            foreach ($shipping as $item_id => $item) {
                $item_resi = isset( $resi[$item_id] ) ? $resi[$item_id] : '';
                $x = $item->get_name();
                $y = $item_resi;
                $z = $item->get_total();
    
                $meta_items1 = $item->get_meta( 'Items' );
                $meta_items = str_replace("&times;", "x", $meta_items1);
                if ($meta_items == '' || empty($meta_items)) {
                    $meta_items = $product_name;
                }
    
                $array_recipt_after[] = "Produk : ".$meta_items."\r\nExpedisi : ".$x."\r\nTarif Ongkir : ".$z;
                $array_recipt[] = "Produk : ".$meta_items."\r\nExpedisi : ".$x."\r\nTarif Ongkir : ".$z."\r\nNo. Resi : ".$y;
            }
        }

        $indo_ongkir_resi = implode("\r\n\r\n", $array_recipt);
        $indo_ongkir = implode("\r\n\r\n", $array_recipt_after);
        
        $shipping_add = [
            'firstname'  => $order->get_shipping_first_name(),
            'lastname'   => $order->get_shipping_last_name(),
            'address1'   => $order->get_shipping_address_1(),
            'address2'   => $order->get_shipping_address_2(),
            'city'       => $order->get_shipping_city(),
            'zipcode'    => $order->get_shipping_postcode(),
            'total'      => $order->get_total(),
            'state_name' => $order->get_shipping_state(),
            'country'    => $order->get_shipping_country(),
        ];

        $data                 = $order->get_data();
        $status               = $order->get_status();
        $version              = $order->get_version();
        $currency             = $order->get_currency();
        $parent_id            = $order->get_parent_id();
        $date_created         = $order->get_date_created();
        $order_comments       = $order->get_customer_note();
        // $payment_method       = $order->get_payment_method();
        $transaction_id       = $order->get_transaction_id();  
        $shipping_method      = $order->get_shipping_method();
        $payment_method       = $this->get_payment_method($order_id);

        $timezone = get_option('timezone_string');
        if (empty($timezone) or $timezone == '') {
            // $timezone="Asia/Jakarta";
        } else {
            date_default_timezone_set($timezone);
        }
        
        $order_date_created = date( 'j F Y, g:i a', strtotime($date_created));

        $date_modified = $order->get_date_modified();
        (isset($date_modified)) ? $timestamp_modified = $date_modified->getTimestamp() : $timestamp_modified = '';
        
        $customer_id    = $data['customer_id'];
        $total          = $order->get_cart_tax();
        $total_tax      = $order->get_total_tax();
        $discount_tax   = $order->get_discount_tax();
        $shipping_tax   = $order->get_shipping_tax();
        $shipping_total = $order->get_shipping_total();
        $discount_total = $order->get_discount_total();

        //# BILLING INFORMATION:
        $billing_city       = $order->get_billing_city();
        $billing_state_code = $order->get_billing_state();
        $billing_email      = $order->get_billing_email();
        $billing_phone      = $order->get_billing_phone();
        $billing_company    = $order->get_billing_company();
        $billing_country    = $order->get_billing_country();
        $billing_postcode   = $order->get_billing_postcode();
        $billing_address_1  = $order->get_billing_address_1();
        $billing_address_2  = $order->get_billing_address_2();
        $billing_last_name  = $order->get_billing_last_name();
        $billing_first_name = $order->get_billing_first_name();
        
        // REMOVE SPACE FROM BILLING PHONE
        $billing_phone      = preg_replace('/(?<=\d)\s+(?=\d)/', '', $billing_phone);
        $no_wa_tujuan = $this->phone_validation($billing_phone, $billing_country);


        $billing_state = WC()->countries->get_states( $billing_country )[$billing_state_code];

        $total_bayar  = number_format($shipping_add['total'], wc_get_price_decimals(), wc_get_price_decimal_separator(), wc_get_price_thousand_separator());
        $total_amount = trim($total_bayar);

        //# SHIPPING INFORMATION:
        $shipping_city       = $order->get_shipping_city();
        $shipping_state      = $order->get_shipping_state();
        $shipping_country    = $order->get_shipping_country();
        $shipping_company    = $order->get_shipping_company();
        $shipping_postcode   = $order->get_shipping_postcode();
        $shipping_last_name  = $order->get_shipping_last_name();
        $shipping_address_1  = $order->get_shipping_address_1();
        $shipping_address_2  = $order->get_shipping_address_2();
        $shipping_first_name = $order->get_shipping_first_name();

        // $shipping_state      = WC()->countries->get_states( $shipping_country )[$shipping_state_code];
        // Get product instruction
        $wc_gateways      = new WC_Payment_Gateways();
        $payment_gateways = $wc_gateways->get_available_payment_gateways();
        $payment_method_ = $order->get_payment_method_title();
        foreach( $payment_gateways as $gateway_id => $gateway ){
            if ($payment_method_ == $gateway->get_title()) {
                $payment_instructions = property_exists( $gateway , 'instructions' ) ? $gateway->instructions : '';
            }
        }

        $site_url = get_site_url();
        $site_url = str_replace('https://', '', $site_url);
        $site_url = str_replace('http://', '', $site_url);
        $site_url = str_replace('www.', '', $site_url);
        $site_url_arr = explode('/', $site_url);
        
        if (is_array($site_url_arr)) {
            $site_url = $site_url_arr[0];
        }

        $reminder_diff_template = get_option(PLUGIN_PREFIX.'_reminder_diff_template');

        if ($type == 'reminder_order') {
            $bulk_template = get_post_meta($order_id, 'bulk_template', true);
            if (!empty($bulk_template)) {
                for ($i = 0; $i < 4; ++$i) {
                    if ($bulk_template == 0) {
                        $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_reminder_order');

                        if (!empty(get_option(PLUGIN_PREFIX.'_check_reminder_order'))) {
                            $data_api['file'] = get_option(PLUGIN_PREFIX.'_pesan_reminder_order_gambar');
                        } else {
                            $data_api['file'] = '';
                        }

                        update_post_meta($order_id, 'bulk_template', '');
                    } elseif ($bulk_template == $i) {
                        $rp_Pesan = get_option(PLUGIN_PREFIX."_pesan_reminder_order$i");

                        if (!empty(get_option(PLUGIN_PREFIX."_check_reminder_order$i"))) {
                            $data_api['file'] = get_option(PLUGIN_PREFIX."_pesan_reminder_order_gambar$i");
                        } else {
                            $data_api['file'] = '';
                        }

                        update_post_meta($order_id, 'bulk_template', '');
                    }
                }
            } else {
                
                $set_pesan = get_post_meta($order_id, 'kirim_wa_ke', true);
                if (empty($reminder_diff_template)) {
                    $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_reminder_order');
                    if (!empty(get_option(PLUGIN_PREFIX.'_check_reminder_order'))) {
                        $data_api['file'] = get_option(PLUGIN_PREFIX.'_pesan_reminder_order_gambar');
                    } else {
                        $data_api['file'] = '';
                    }
                } else {
                    for ($i = 1; $i <= 3; ++$i) {
                        if ($set_pesan == 0) {
                            $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_reminder_order');
                            if (!empty(get_option(PLUGIN_PREFIX.'_check_reminder_order'))) {
                                $data_api['file'] = get_option(PLUGIN_PREFIX.'_pesan_reminder_order_gambar');
                            } else {
                                $data_api['file'] = '';
                            }
                        } elseif ($set_pesan == $i) {
                            update_post_meta($order_id, 'kirim_wa_ke', $i);
                            $rp_Pesan = get_option(PLUGIN_PREFIX."_pesan_reminder_order$i");
                            if (!empty(get_option(PLUGIN_PREFIX."_check_reminder_order$i"))) {
                                $data_api['file'] = get_option(PLUGIN_PREFIX."_pesan_reminder_order_gambar$i");
                            } else {
                                $data_api['file'] = '';
                            }
                        }
                    }
                }
            }
        } else {
            $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_'.$type);
        }

        $rp_Pesan=str_replace("'","",$rp_Pesan);
        $rp_Pesan=str_replace('"',"",$rp_Pesan);
        $rp_Pesan=str_replace('$',"",$rp_Pesan);
        // with eval
        // $rp_Pesan = str_replace('{', '$', $rp_Pesan);
        // $rp_Pesan = str_replace('}', '', $rp_Pesan);
        // $pesan_eval = '$isi="'.$rp_Pesan.'";';
        // eval($pesan_eval);

        // replace eval function
        $shortcode = array(
            '{billing_first_name}',
            '{billing_last_name}',
            '{billing_address_1}',
            '{billing_address_2}',
            '{billing_city}',
            '{billing_state}',
            '{billing_postcode}',
            '{billing_country}',
            '{billing_email}',
            '{billing_phone}',
            '{billing_company}',
            '{billing_cpf}',
            '{billing_cnpj}',
            '{billing_rg}',
            '{billing_number}',
            '{billing_neighborhood}',
            '{billing_sex}',
            '{billing_ie}',
            '{shipping_first_name}',
            '{shipping_last_name}',
            '{shipping_address_1}',
            '{shipping_address_2}',
            '{shipping_city}',
            '{shipping_state}',
            '{shipping_postcode}',
            '{shipping_company}',
            '{shipping_country}',
            '{shipping_number}',
            '{shipping_neighborhood}',
            '{shipping_method}',
            '{order_comments}',
            '{product_name}',
            '{product_instructions}',
            '{product_name_no_qty}',
            '{product_digital_link}',
            '{total_amount}',
            '{payment_method}',
            '{payment_instructions}',
            '{nwa_additional_info}',
            '{indo_ongkir}',
            '{indo_ongkir_resi}',
            '{order_id}',
            '{product_name}',
            '{product_link}',
            '{product_name_link}',
            '{order_date_created}',
            '{site_url}',
            '{ast_no_resi}'
        );
        $isi_shortcode=array(
            $billing_first_name,
            $billing_last_name,
            $billing_address_1,
            $billing_address_2,
            $billing_city,
            $billing_state,
            $billing_postcode,
            $billing_country,
            $billing_email,
            $billing_phone,
            $billing_company,
            $billing_cpf,
            $billing_cnpj,
            $billing_rg,
            $billing_number,
            $billing_neighborhood,
            $billing_sex,
            $billing_ie,
            $shipping_first_name,
            $shipping_last_name,
            $shipping_address_1,
            $shipping_address_2,
            $shipping_city,
            $shipping_state,
            $shipping_postcode,
            $shipping_company,
            $shipping_country,
            $shipping_number,
            $shipping_neighborhood,
            $shipping_method,
            $order_comments,
            $product_name,
            $product_instructions,
            $product_name_no_qty,
            $product_digital_link,
            $total_amount,
            $payment_method,
            $payment_instructions,
            $nwa_additional_info,
            $indo_ongkir,
            $indo_ongkir_resi,
            $order_id,
            $product_name,
            $product_link,
            $product_name_link,
            $order_date_created,
            $site_url,
            $ast_no_resi
        );
        $isi = str_replace($shortcode,$isi_shortcode,$rp_Pesan);
        $isi = str_replace($postmeta_key,$postmeta_val,$isi);

        $text = stripslashes($isi);
        $text = str_replace("\'", "'", $text);

        $today              = date('Y-m-d H:i');
        $gmt                = get_option('gmt_offset');
        $timezone           = get_option('timezone_string');
        $schedule_number    = get_option(PLUGIN_PREFIX.'_schedule_number');
        $time_followup      = get_option('time_order_complete_followup');
        $togggle_followup   = get_option(PLUGIN_PREFIX.'_toggle_order_complete_followup');
        $time_type          = get_option(PLUGIN_PREFIX.'_time_type_followup_order_completed');
        $time_limit         = get_option(PLUGIN_PREFIX.'_time_limit_followup_order_completed');
        $send_followup      = '';

        if (!empty(get_option('timezone_string'))) {
            date_default_timezone_set($timezone);
            $today = date('Y-m-d H:i');
        }else {
            $today = gmdate("Y-m-d H:i", time() + 3600*($gmt+date("I")));
        }

        if ($type == 'order_complete_followup') {
            if ($time_type == 'day') {
                $send_followup = date('Y-m-d H:i', strtotime($today .'+'. $time_limit.' days', strtotime($today)));
            }else {
                $send_followup = date('Y-m-d H:i', strtotime($today .'+'. $time_limit.' hours', strtotime($today)));
            }
        }

        $customfilename = NWA_PATH.'modules/custom_features/custom_features.php';
        if (file_exists($customfilename)) {
            if ($type == 'pending_payment') {
                if (get_option(PLUGIN_PREFIX.'_toggle_pending_payment_custom') == 'checked') {
                    $json = get_option(PLUGIN_PREFIX.'_pp_custom_features_data');
                    $arrray_customfeatures = json_decode($json);
                    
                    foreach ($arrray_customfeatures as $key => $value) {
                        if (strtolower($value->title) == strtolower($payment_method_title)) {
                            $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_pp_custom_features'.$key);
                        }
                    }
                }
            }

            if ($type == 'order_complete') {
                if (get_option(PLUGIN_PREFIX.'_toggle_order_completed_custom') == 'checked') {
                    $json = get_option(PLUGIN_PREFIX.'_oc_custom_features_data');
                    $arrray_customfeatures = json_decode($json);
                    
                    foreach ($arrray_customfeatures as $key => $value) {
                        if (strtolower($value->title) == strtolower($shipping_method)) {
                            $rp_Pesan = get_option(PLUGIN_PREFIX.'_pesan_oc_custom_features'.$key);
                        }
                    }
                }
            }

            if (substr('order_complete_followup', 0, 23) == 'order_complete_followup') {
                if (get_option(PLUGIN_PREFIX.'_toggle_orderfollowup_custom') == 'checked') {
                    $json = get_option(PLUGIN_PREFIX.'_order_followup_custom_data');
                    $arrray_customfeatures = json_decode($json);
                    $time_type  = get_option(PLUGIN_PREFIX."_time_type_".$type);
                    $time_limit = get_option(PLUGIN_PREFIX."_time_limit_".$type);
                    
                    $order_followup_time = get_post_meta($order_id, 'order_followup_time', true);
                    if ($order_followup_time == '' || empty($order_followup_time) || $order_followup_time < $today) {
                        $order_followup_time = $today;
                    }


                    if ($time_type == 'day') {
                        $send_followup = date('Y-m-d H:i', strtotime($order_followup_time .'+'. $time_limit.' days', strtotime($order_followup_time)));
                        update_post_meta($order_id, 'order_followup_time', $send_followup);
                    }else {
                        $send_followup = date('Y-m-d H:i', strtotime($order_followup_time .'+'. $time_limit.' hours', strtotime($order_followup_time)));
                        update_post_meta($order_id, 'order_followup_time', $send_followup);
                    }
                }
            }
        }


        // $all_bank_account = $no_rek_all;
        // if (empty($billing_phone)) {
        //     $billing_phone = $order->get_shipping_phone();
        //     if (empty($billing_phone)) {
        //         $billing_phone = get_post_meta($order_id, '_shipping_phone', true);
        //     }
        // }

        // pengecekan file untuk dikirim

        if (get_option(PLUGIN_PREFIX.'_license_type') != 'android') {
            if ($type != 'reminder_order') {
                if (!empty(get_option(PLUGIN_PREFIX."_check_$type"))) {
                    if (!empty(get_option(PLUGIN_PREFIX."_image_$type"))) {
                        $data_api['file'] = get_option(PLUGIN_PREFIX."_image_$type");
                    }
                } else {
                    $data_api['file'] = '';
                }
            }
        }

        $bdata = array(
            'kota'         => $billing_city,
            'produk'       => $product_name,
            'nama_pembeli' => "$billing_first_name $billing_last_name",
            'email'        => $billing_email,
            'no_hp'        => $billing_phone,
            'provinsi'     => $billing_state,
            'negara'       => $billing_country,
            'alamat'       => "$billing_address_1 $billing_address_2",
            'kodepos'      => $billing_postcode,
        );

        $ip  = trim(get_option(PLUGIN_PREFIX.'_ip'));

        if (get_option(PLUGIN_PREFIX.'_toggle_token') == 'checked' && get_option(PLUGIN_PREFIX.'_license_type') != 'android') {
            $key = $this->get_key_token($order_id, $type);
        }else {
            $key = get_option(PLUGIN_PREFIX.'_api_key');
            if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm') {
                $key = get_option(PLUGIN_PREFIX.'_token_crm');
            }
        }

        $data_api['ip']           = $ip;
        $data_api['key']          = $key;
        $data_api['text']         = $text;
        $data_api['type']         = $type;
        $data_api['domain']       = $site_url;
        $data_api['order_id']     = $order_id;
        $data_api['no_wa_tujuan'] = $no_wa_tujuan;
        $data_api['country_code'] = $billing_country;
        $data_api['bdata']        = json_encode($bdata);
        // $data_api['crm_token']    = get_option(PLUGIN_PREFIX.'_token_crm');
        $data_api['license']      = get_option(PLUGIN_PREFIX.'_license_number');
        $data_api['order_complete_followup'] = $send_followup;

        $return['data_api'] = $data_api;

        return $return;
    }

    public function get_payment_method($order_id){
        $order = wc_get_order($order_id);
        $payment_name = $order->get_payment_method();
        $payment_name = str_replace('_', ' ', $payment_name);
        if(strpos($payment_name, 'tripay') !== false){
            $apiKey = get_option('tripay_api_key');

			$reference = get_post_meta($order_id,'_tripay_payment_reference',true);

			$payload = [
				'reference'	=> $reference
			];

			$curl = curl_init();

			curl_setopt_array($curl, array(
			CURLOPT_FRESH_CONNECT     => true,
			CURLOPT_URL               => "https://tripay.co.id/api/transaction/detail?".http_build_query($payload),
			CURLOPT_RETURNTRANSFER    => true,
			CURLOPT_HEADER            => false,
			CURLOPT_HTTPHEADER        => array(
				"Authorization: Bearer ".$apiKey
			),
			CURLOPT_FAILONERROR       => false,
			));

			$response = curl_exec($curl);
			$err = curl_error($curl);

			curl_close($curl);
			$data =  json_decode($response);
			$payment_method .= $data->data->payment_name ."\n"; 
			$payment_method .= $data->data->pay_code."\n";
        }elseif(strpos($payment_name, 'duitku') !== false){
            // $merchantCode = get_option('duitku_merchant_code'); // from duitku
            // $merchantKey = get_option('duitku_api_key'); // from duitku
            // $endpoint	= rtrim(get_option('duitku_endpoint'), '/');
            // $_paymentAmount = $order->get_total(); // minimal 10k
            // $paymentAmount  = number_format($_paymentAmount, wc_get_price_decimals(), wc_get_price_decimal_separator(), wc_get_price_thousand_separator());
            // $paymentAmount = trim($paymentAmount); // minimal 10k
            // $_paymentMethod = $this->get_payment_method_duitku($payment_name); // VC = Credit Card

            // $paymentMethod = $_paymentMethod['payment_code']; // VC = Credit Card
            // $merchantOrderId = time() . ''; // from merchant, unique
            // $expiryPeriod = 10; // set the expired time in minutes
            // $signature = md5($merchantCode . $merchantOrderId . $_paymentAmount . $merchantKey);
            // $url = $endpoint.'/api/merchant/v2/inquiry';
        
            // $params = array(
            //     'merchantCode' => $merchantCode,
            //     'paymentAmount' => $_paymentAmount,
            //     'paymentMethod' => $paymentMethod,
            //     'merchantOrderId' => $merchantOrderId,
            //     'signature' => $signature,
            //     'expiryPeriod' => $expiryPeriod
        
            // );
            
            // $headers = array('Content-Type' => 'application/json');
            // $response = wp_remote_post($url, array(
            //     'method' => 'POST', 'body' => json_encode($params), 'timeout' => 90, 'sslverify' => false, 'headers' => $headers,
            // ));
        
            // $response_body = wp_remote_retrieve_body($response);
            // $resp = json_decode($response_body);

            // $payment_method .= $_paymentMethod['payment_name']."\n";
            // $payment_method .= $resp->vaNumber."\n";
            // $payment_method .= "Rp. ".$paymentAmount."\n";

            
            $payment_page_id = wc_get_page_id( 'pay' );
            $payment_page_url = $payment_page_id ? get_permalink( $payment_page_id ) : '';
            if($payment_page_id){
                $payment_method .= $payment_page_url . 'order-pay/'.$order_id.'/?pay_for_order=true&key='. get_post_meta($order_id,'_order_key',true) ."\n";

                $payment_method .= "\n";
            }
        }elseif (strpos($payment_name, 'bacs') !== false) {
            $bacs = get_option( 'woocommerce_bacs_accounts'); 
            $payment_method = '';
            foreach ($bacs as $key => $value) {
                $payment_method .= $value['account_name']."\n";
                $payment_method .= $value['account_number']."\n";
                $payment_method .= $value['bank_name']."\n";
            }
            // $payment_method       = $order->get_payment_method_title();
        }elseif (strpos($payment_name, 'xendit') !== false) {
            $setting = get_option('woocommerce_xendit_gateway_settings');
            $secret_key = $setting['secret_key'];
            $key = base64_encode($secret_key . ':');
            $basicauth = 'Basic ' . $key;

            $headers = array( 
                'Authorization' => $basicauth,
            );

            $pload = array(
                'headers' => $headers,
            );
            $url = 'https://api.xendit.co/v2/invoices/'. get_post_meta($order_id,'Xendit_invoice',true);
            $response = wp_remote_get($url, $pload);
			
			$data =  json_decode($response['body'],1);
			$bank = explode("- ", get_post_meta($order_id,'_payment_method_title',true));
			$payment_method = '';
			$pm = get_post_meta($order_id,'_payment_method',true);
			$pm = ltrim($pm,'xendit_');
			$pm = rtrim($pm,'va');

			foreach ($data['available_banks'] as $key => $value) {
				if (strtolower($pm)!==strtolower($value['bank_code'])) {
					continue;
				}

				$payment_method .= $value['bank_code']."\n";
				$payment_method .= $value['bank_account_number']."\n";
				$payment_method .= $value['account_holder_name']."\n";
                $payment_method .= $value['transfer_amount']."\n\n";
			    $payment_method .= "Expired: *". date('d-m-Y H:i', get_post_meta($order_id,'Xendit_expiry',true)) ."*";
			}
			if ($payment_method == '') {
				foreach ($data['available_retail_outlets'] as $key => $value) {
					if (strtolower($pm)!==strtolower($value['retail_outlet_name'])) {
						continue;
					}
					$payment_method .= $value['retail_outlet_name']."\n";
					$payment_method .= $value['payment_code']."\n";
					$payment_method .= "Expired: *". date('d-m-Y H:i', get_post_meta($order_id,'Xendit_expiry',true)) ."*";
				}
			}
			if ($payment_method == '') {
				$payment_method .= get_post_meta($order_id,'_payment_method_title',true)."\n";
				$payment_method .= "Expired: *". date('d-m-Y H:i', get_post_meta($order_id,'Xendit_expiry',true)) ."*";
			}
        }elseif(strpos($payment_name, 'toyyibPay') !== false){
            $payment_page_id = wc_get_page_id( 'pay' );
            $payment_page_url = $payment_page_id ? get_permalink( $payment_page_id ) : '';
            if($payment_page_id){
                $payment_method .= $payment_page_url . 'order-pay/'.$order_id.'/?pay_for_order=true&key='. get_post_meta($order_id,'_order_key',true) ."\n";
            }
        }elseif(strpos($payment_name, 'midtrans') !== false){
            $payment_method = get_post_meta($order_id, '_mt_payment_url', true);
        }else {
            $payment_method = $order->get_payment_method_title();
        }
        
        return $payment_method;
    }

    function get_payment_method_duitku($payment_method){
        $payment_method_array = [];
        if (strpos($payment_method, 'duitku_va_bni') !== false) {
            $payment_method_array['payment_code'] = 'I1';
            $payment_method_array['payment_name'] = 'BNI Virtual Account';
            $payment_method_array['payment_code_number'] = '009';
        }elseif (strpos($payment_method, 'duitku_ovo') !== false) {
            $payment_method_array['payment_code'] = 'OV';
            $payment_method_array['payment_name'] = 'OVO';
            $payment_method_array['payment_code_number'] = '-';
        }elseif (strpos($payment_method, 'duitku_credit_card') !== false) {
            $payment_method_array['payment_code'] = 'VC';
            $payment_method_array['payment_name'] = '	Credit Card (Visa / Master)';
            $payment_method_array['payment_code_number'] = '-';
        }elseif (strpos($payment_method, 'duitku_bca') !== false) {
            $payment_method_array['payment_code'] = 'BK';
            $payment_method_array['payment_name'] = 'BCA KlikPay';
            $payment_method_array['payment_code_number'] = '014';
        }elseif (strpos($payment_method, 'duitku_va_atm_bersama') !== false) {
            $payment_method_array['payment_code'] = 'A1';
            $payment_method_array['payment_name'] = 'ATM Bersama';
            $payment_method_array['payment_code_number'] = '-';
        }elseif (strpos($payment_method, 'duitku_va_mandiri') !== false) {
            $payment_method_array['payment_code'] = 'M1';
            $payment_method_array['payment_name'] = 'Mandiri Virtual Account';
            $payment_method_array['payment_code_number'] = '008';
        }elseif (strpos($payment_method, 'duitku_va_mandiri_h2h') !== false) {
            $payment_method_array['payment_code'] = 'M2';
            $payment_method_array['payment_name'] = 'Mandiri Virtual Account';
            $payment_method_array['payment_code_number'] = 'M2';
        }elseif (strpos($payment_method, 'duitku_va_cimb_niaga') !== false) {
            $payment_method_array['payment_code'] = 'B1';
            $payment_method_array['payment_name'] = 'CIMB Niaga Virtual Account';
            $payment_method_array['payment_code_number'] = '022';
        }elseif (strpos($payment_method, 'duitku_va_ritel') !== false) {
            $payment_method_array['payment_code'] = 'FT';
            $payment_method_array['payment_name'] = 'Alfamart/Pagedaian/Kantor Pos';
            $payment_method_array['payment_code_number'] = '-';
        }elseif (strpos($payment_method, 'duitku_shopee') !== false) {
            $payment_method_array['payment_code'] = 'SP';
            $payment_method_array['payment_name'] = 'Shopee Pay';
            $payment_method_array['payment_code_number'] = '-';
        }elseif (strpos($payment_method, 'duitku_indodana') !== false) {
            $payment_method_array['payment_code'] = 'DN';
            $payment_method_array['payment_name'] = 'Indodana Paylater';
            $payment_method_array['payment_code_number'] = '-';
        }elseif (strpos($payment_method, 'duitku_shopeepay_applink') !== false) {
            $payment_method_array['payment_code'] = 'SA';
            $payment_method_array['payment_name'] = 'Shopee Pay Apps';
            $payment_method_array['payment_code_number'] = '-';
        }elseif (strpos($payment_method, 'duitku_linkaja_applink') !== false) {
            $payment_method_array['payment_code'] = 'LA';
            $payment_method_array['payment_name'] = 'LinkAja Apps';
            $payment_method_array['payment_code_number'] = 'LA';
        }elseif (strpos($payment_method, 'duitku_va_bca') !== false) {
            $payment_method_array['payment_code'] = 'BC';
            $payment_method_array['payment_name'] = 'BCA Virtual Account';
            $payment_method_array['payment_code_number'] = '014';
        }elseif (strpos($payment_method, 'duitku_credit_card_migs') !== false) {
            $payment_method_array['payment_code'] = 'MG';
            $payment_method_array['payment_name'] = 'Credit Card';
            $payment_method_array['payment_code_number'] = '-';
        }
        return $payment_method_array;
    }

    public function phone_validation($billing_phone, $billing_country=''){
        $nom = trim($billing_phone);
        $nom = filter_var($nom, FILTER_SANITIZE_NUMBER_INT);
        $nom = str_replace("-","",$nom);
        $nom = str_replace("+","",$nom);
        $nom = str_replace("(","",$nom);
        $nom = str_replace(")","",$nom);
        $nom = str_replace(" ","",$nom);
        $kode = get_option(PLUGIN_PREFIX.'_default_country_code');
        $kodelength = strlen(get_option(PLUGIN_PREFIX.'_default_country_code'));
        
        if(class_exists('WooPhoneInput_Init') || get_option(PLUGIN_PREFIX.'_toggle_country_code') == true){ 
            if(get_option(PLUGIN_PREFIX.'_toggle_country_code') == true && substr($nom,0,1)!="0"){
                $no_wa_tujuan = '+'.$nom;
            }else {
                if(substr($nom,0,1)=="0"){
                    if ($kode=="62") {
                        // indonesia depan 0 jadi +62
                        $no_wa_tujuan = '+'.$kode.$nom;
                        $no_wa_tujuan = str_replace("+0","+62",$no_wa_tujuan);
                        $no_wa_tujuan = str_replace("+620","+62",$no_wa_tujuan);
                    }elseif ($kode=="60") {
                        // malaysia depan 0 jadi +60
                        $no_wa_tujuan = '+6'.$nom;  
                        $no_wa_tujuan = str_replace("+600","+60",$no_wa_tujuan);   
                    }elseif ($kode=="972") {
                        // israel depan 0 jadi +60
                        $no_wa_tujuan = '+972'.$nom;  
                        $no_wa_tujuan = str_replace("+9720","+972",$no_wa_tujuan);   
                    }elseif ($kode=="27") {
                        // cameroon depan 0 jadi +27
                        $no_wa_tujuan = '+27'.$nom;  
                        $no_wa_tujuan = str_replace("+270","+27",$no_wa_tujuan);   
                    }elseif ($kode=="+966") {
                        // arabic depan 0 jadi +27
                        $no_wa_tujuan = '+966'.$nom; 
                        $no_wa_tujuan = str_replace("+9660","+966",$no_wa_tujuan);   
                    }elseif ($kode=="+44") {
                        // arabic depan 0 jadi +27
                        $no_wa_tujuan = '+44'.$nom; 
                        $no_wa_tujuan = str_replace("+440","+44",$no_wa_tujuan);   
                    }
                }else{
                    $no_wa_tujuan = '+'.$kode.$nom;
                }
            }
        }else{
            $no_wa_tujuan = '+'.$nom;
                $kode = get_option(PLUGIN_PREFIX.'_default_country_code');
                if($kode==""){
                    if(substr($nom,0,2)=="62"){
                        $no_wa_tujuan = '+'.$nom;
                    }elseif(substr($nom,0,1)=="0"){
                        $no_wa_tujuan = '+62'.$nom;
                        $no_wa_tujuan = str_replace("+620","+62",$no_wa_tujuan);
                    }else{
                        $no_wa_tujuan = '+'.$nom;
                    }
                }elseif($kode == "55"){ //brazil
                    $c = substr($nom,0,2);
                    if( $c == "62" ){
                        $no_wa_tujuan = '+'.$kode.$nom;	
                    }else{
                        $no_wa_tujuan = '+55'.$nom;
                        $no_wa_tujuan = str_replace("+5555","+55",$no_wa_tujuan);
                    }
                }elseif($kode == "971"){ //uea
                    $c = substr($nom,0,3);
                    if( $c == "62" ){
                        $no_wa_tujuan = '+'.$kode.$nom;	
                    }else{
                        $no_wa_tujuan = '+971'.$nom;
                        $no_wa_tujuan = str_replace("+971971","+971",$no_wa_tujuan);
                    }
                }else{
                    if(substr($nom,0,2)==$kode){
                        $no_wa_tujuan = '+'.$nom;
                    }elseif(substr($nom,0,1)=="0"){
                        if ($kode=="62") {
                            // indonesia depan 0 jadi +62
                            $no_wa_tujuan = '+'.$kode.$nom;
                            $no_wa_tujuan = str_replace("+0","+62",$no_wa_tujuan);
                            $no_wa_tujuan = str_replace("+620","+62",$no_wa_tujuan);
                        }elseif ($kode=="60") {
                            // malaysia depan 0 jadi +60
                            $no_wa_tujuan = '+6'.$nom;  
                            $no_wa_tujuan = str_replace("+600","+60",$no_wa_tujuan);
                        }else{
                            $no_wa_tujuan = '+'.$kode.$nom;
                        }
                    }else{
                        $no_wa_tujuan = '+'.$nom;
                    }
                }
            $no_wa_tujuan = str_replace("++","+",$no_wa_tujuan);
        }
        return $no_wa_tujuan;
    }

    public function writelog($n){
        if($n != ''){
            $timezone = get_option('timezone_string');
            if (empty($timezone) or $timezone == '') {
                // $timezone="Asia/Jakarta";
            } else {
                date_default_timezone_set($timezone);
            }
            $fp = fopen(__DIR__.'/../error/error.log', 'a');
            $notallow = array('select ', 'insert ', 'replace ', 'order by', 'group by', 'update ', '{', 'http');
            $tulis = 0;
            foreach ($notallow as $k) {
                if (strpos(strtolower($n), 'select') !== false) {
                } else {
                    $tulis = 1;
                }
            }
            if ($tulis == 1) {
                if (empty($timezone)) {
                    $gmt = get_option('gmt_offset');
                    $date = gmdate("d-m-Y H:i:s", time() + 3600*($gmt+date("I")));
                    fwrite($fp, $date.' :: '.$n."\n");
                }else {
                    fwrite($fp, date('d-m-Y H:i:s').' :: '.$n."\n");
                }
            }
            fclose($fp);
        }
    }

    public function get_key_token($order_id, $type){
        $json = get_option(PLUGIN_PREFIX.'_token_data');
        $license_key = get_option(PLUGIN_PREFIX.'_api_key');
        
        if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm') {
            $json = get_option(PLUGIN_PREFIX.'_token_data_crm');
            $license_key = get_option(PLUGIN_PREFIX.'_token_crm');
        }
        
        $data = json_decode($json, 1);
        $count = count($data);
        $keytoken = get_option(PLUGIN_PREFIX.'_order_number_token');
        $type   = str_replace('_', ' ', $type);
        $type   = strtolower($type);
        
        if ($keytoken == 0 && strpos($type, 'seller') === false) {
            if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm') {
                $token = get_option(PLUGIN_PREFIX.'_token_crm');
            }
            $token = get_option(PLUGIN_PREFIX.'_api_key');
            update_post_meta($order_id, 'nwa_key_sender', $token);
            update_option(PLUGIN_PREFIX.'_order_number_token', 1);
            
            return $token;
        }
        
        
        if (get_post_meta($order_id, 'nwa_key_sender', true) != $license_key) {
            // $tokens = array();
            $tokens = array_column($data, 'token');
            if (!empty($tokens)) {
                if (in_array(get_post_meta($order_id, 'nwa_key_sender', true), $tokens) == false) {
                    update_post_meta($order_id, 'nwa_key_sender', '');
                }
            }else {
                nwa_writelog(__('Key is empty', 'notifier-for-phone'));
            }
        }
        
        if (!empty(get_post_meta($order_id, 'nwa_key_sender', true))) {
            $token = get_post_meta($order_id, 'nwa_key_sender', true);
        }else {
            foreach ($data as $key => $value) {
                $token = '';
                $toggle_token = get_option(PLUGIN_PREFIX.'_toggle_token'.$key);
                if ($key == $keytoken && $token == '') {
                    if (!empty($toggle_token)) {
                        $token = $value['token'];
                        update_post_meta($order_id, 'nwa_key_sender', $token);
                        update_option(PLUGIN_PREFIX.'_order_number_token', $keytoken+1);
                        
                        break;
                    }else {
                        $keytoken = $keytoken+1;
                    }
                }
            }
        }
        
        if (strpos($type, 'seller') === false && get_option(PLUGIN_PREFIX.'_order_number_token') > $count) {
            
            // $keytoken = update_option(PLUGIN_PREFIX.'_order_number_token', $keytoken+1);
            // $token = get_option(PLUGIN_PREFIX.'_api_key');
            // if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm') {
            //     $token = get_option(PLUGIN_PREFIX.'_token_crm');
            // }
            // update_post_meta($order_id, 'nwa_key_sender', $token);
            update_option(PLUGIN_PREFIX.'_order_number_token', 0);
            
            // if (get_option(PLUGIN_PREFIX.'_order_number_token') > $count && $token == '') {
            //     $token = get_option(PLUGIN_PREFIX.'_api_key');
            //     if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm') {
            //         $token = get_option(PLUGIN_PREFIX.'_token_crm');
            //     }
            //     update_post_meta($order_id, 'nwa_key_sender', $token);
            //     update_option(PLUGIN_PREFIX.'_order_number_token', 1);
            // }
        }
        
        if(empty($token) || $token =''){
            $token = get_option(PLUGIN_PREFIX.'_api_key');
            update_post_meta($order_id, 'nwa_key_sender', $token);
        }else {
            $token = get_post_meta($order_id, 'nwa_key_sender', true);
        }

        return $token;
    }
}