<?php

add_action( 'add_meta_boxes', 'create_notifier_product_instruction_meta_box' );
function create_notifier_product_instruction_meta_box() {
    add_meta_box(
        'custom_product_meta_box',
        ''.PLUGIN_PREFIX.' Product Instruction', 'cmb',
        'add_custom_content_meta_box',
        'product',
        'normal',
        'default'
    );
}

function add_custom_content_meta_box( $post ){
	$product = wc_get_product($post->ID);
	$content = $product->get_meta( '_instruction' );

    echo '<div class="notifier_product_instruction">';
	$editor_id = 'notifier_product_instruction';
	$settings = array(
		'textarea_name' => '_instruction',
		'textarea_rows' => 10,
		'media_buttons' => FALSE,
		'quicktags' => FALSE,
		'tinymce'       => array(
			'toolbar1'      => '',
			'toolbar2'      => '',
			'toolbar'      => false,
		),	
	);
	wp_editor( $content, $editor_id, $settings );

    echo '</div>';
}

add_action( 'woocommerce_admin_process_product_object', 'save_product_custom_wysiwyg_field', 10, 1 );
function save_product_custom_wysiwyg_field( $product ) {
    if (  isset( $_POST['_instruction'] ) )
		$product->update_meta_data( '_instruction', wp_kses_post( $_POST['_instruction'] ) );
}

// add_filter( 'woocommerce_product_tabs', 'add_instruction_product_tab', 10, 1 );
function add_instruction_product_tab( $tabs ) {
    $tabs['test_tab'] = array(
        'title'         => __( 'Product instruction', 'woocommerce' ),
        'priority'      => 50,
        'callback'      => 'display_instruction_product_tab_content'

    );

    return $tabs;
}

function display_instruction_product_tab_content() {
    global $product;
    echo '<div class="wrapper-notifier_product_instruction">' . $product->get_meta( '_instruction' ) . '</div>';
}