<?php

$ip = get_option(PLUGIN_PREFIX.'_ip');
$key = get_option(PLUGIN_PREFIX.'_api_key');

if (get_option(PLUGIN_PREFIX.'_license') == 'active' && get_option(PLUGIN_PREFIX.'_license_type') == '') {
   if (empty($ip or $key)) {
      add_action( 'admin_notices', 'nwa_error_key_api' );
   }
}

function nwa_error_key_api() {
	$class = 'notice notice-error';
	$message = PLUGIN_PREFIX . __('Notice : Please insert your Key !', 'notifier-for-phone').' <a href="'.site_url().'/wp-admin/admin.php?page=notifierforphone-main-menu&tab=license">'.__('Here', 'notifier-for-phone').'</a>'. site_url();

	printf( '<div style="margin-left: 0px;" class="%1$s"><p>%2$s</p></div>', esc_attr( $class ),  $message  ); 
}

function nwa_license_view(){
   $script = nwa_script_license_notif();

   if( isset( $_POST['submit'] ) && sanitize_text_field ( $_POST['action'] ) == "activate" ){ 
      $res=nwa_activate_license_callback($_POST); 
   }elseif( isset( $_POST['submit'] ) && sanitize_text_field ( $_POST['action'] ) == "deactivate" ){
      $res=nwa_deactivate_license_callback(); 
   } 

   $status_license=get_option(PLUGIN_PREFIX."_license");
   if (empty($status_license)) {
      add_option(PLUGIN_PREFIX."_license","",null,'no');
   }

   if (empty(get_option(PLUGIN_PREFIX."_license_number"))) {
      add_option(PLUGIN_PREFIX."_license_number","",null,'no');
   }

   if (isset( $_POST['submit'] )) {
      header("location:".site_url()."/wp-admin/admin.php?page=notifierforphone-main-menu&tab=license&n=$res");
      wp_die();
   }

   if (empty($status_license) or $status_license=='deactive') {
      $form='<input id="my-license" type="text" name="my-license" value="" required="required"> 
      <input type="hidden" name="action" value="activate">
      <input type="submit" name="submit" value="Activate" class="btn btn-success"> ';
   }else{
      $form='<input id="my-license" type="hidden" name="my-license" value="'.get_option(PLUGIN_PREFIX.'_license_number').'" required="required"> 
      <input type="hidden" name="action" value="deactivate"> 
      <input type="submit" name="submit" value="Deactivate" class="btn btn-danger"> ';
   }

   $n='';
   if (isset($_GET['n'])) {
      $n.=$_GET['n']."<br>";
   }

   $tgl_expired = nwa_cek_license_expired();
   if ( get_option(PLUGIN_PREFIX.'_license_number') !== false and get_option(PLUGIN_PREFIX.'_license_number')!='') {
      if ($tgl_expired == ("0000-00-00") or $tgl_expired == '') {
         $n = '';
      }else {
         $n.=__('License will expired at', 'notifier-for-phone'). ' <b>'.date('d-m-Y',strtotime($tgl_expired));
      }
      
   }


   $ip = get_option(PLUGIN_PREFIX.'_ip');
   $key = get_option(PLUGIN_PREFIX.'_api_key');
   $license = get_option(PLUGIN_PREFIX.'_license_number');
   $ip_used = '';
   $key_used = '';
   $form_token = '';
   
   if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm' && !empty(get_option(PLUGIN_PREFIX.'_license_number'))) {
      $key = get_option(PLUGIN_PREFIX.'_token_crm');
      $ip = '';
   }

   //$form_ip = '<br><span>IP </span><br><input id="my-ip" type="text" name="my-ip" value="" placeholder="IP Here">';
   $form_ip = '';
   $form_key = '';
   if (get_option(PLUGIN_PREFIX.'_license_type') == '') {
      $form_key = '<br><span>Key </span><br><input id="my-key" type="text" name="my-key" value="" placeholder="Key Here"> <br><br>
      <p>'.__('Where can i find my Key?', 'notifier-for-phone').'<br>'.__(' Go ', 'notifier-for-phone').'<a href="https://app.qweasd123.com/dashboard/" target="_blank">'.__('Here', 'notifier-for-phone').'</a>'.__(' > More > Key', 'notifier-for-phone').'</p>
      <br><button class="btn btn-success btn-sm" onclick="return get_ip_key();" name="save_ip_key">Save</button>';
   }else if(get_option(PLUGIN_PREFIX.'_license_type') == 'crm' && empty(get_option(PLUGIN_PREFIX.'_token_crm')) && !empty(get_option(PLUGIN_PREFIX.'_license_number')) ){
      $form_token = '<br><span>Token </span><br><input id="my-token" type="text" name="my-token" value="" placeholder="Token Here"> <br><br>
      <p>'.__('You have to set your default token', 'notifier-for-phone').'<br>'.__('Where can i find my Token?', 'notifier-for-phone').'<br> <button type="button" class="btn btn-xs btn-primary" data-target="#getcrmtoken" style="margin-bottom:13px" data-toggle="modal">Here</button>
      <br><button class="btn btn-success btn-sm" onclick="return get_token();" name="save_token">Save</button>';
   }

   (empty($license)) ? $license_used = '' : $license_used = '<br><span>'.__('License', 'notifier-for-phone').' </span><br>********'.substr($license, -5, 5);

   if (get_option(PLUGIN_PREFIX.'_license') == 'active' && get_option(PLUGIN_PREFIX.'_license_type') != 'android') {
      (empty($ip)) ? $ip_used = $form_ip : $ip_used = '<br><span>IP <br> ********'.substr($ip, -8, 8);
      (empty($key)) ? $key_used = $form_key : $key_used = '<br><span>Key <br>********'.substr($key, -8, 8);   
   }
   if(get_option(PLUGIN_PREFIX.'_default_country_code_huruf') !== false and get_option(PLUGIN_PREFIX.'_default_country_code_huruf')!=''){
      $default_country=get_option(PLUGIN_PREFIX.'_default_country_code_huruf');
   }
   $html= '<h1 class="wp-heading-inline" style="display: inline-block;">'.PLUGIN_NAME.'\'s  License</h1> <button type="button" class="btn btn-xs btn-primary" data-target="#tooltiplicense" style="margin-bottom:13px" data-toggle="modal"><i class="fas fa-question"></i></button>
   <form method="post"> 
      <label for="my-license">'.__('License', 'notifier-for-phone').'</label> 
      '.$form.'
   </form>
   <form method="post">
      <br> '.$n.'</b><br>
      '.$license_used.'
      '.$key_used.'
      '.$form_token.'
   </form> ';

   if (get_option(PLUGIN_PREFIX."_license") == 'active' && get_option(PLUGIN_PREFIX.'_license_type') == '') {
      $html.='
      <div style="margin-top:30px;">
         <span>'.__('Test License', 'notifier-for-phone').'</span>
      </div>
      <div class="">
         <label for="send_to">'.__('Whatsapp Number:', 'notifier-for-phone').'</label>
         <input name="send_to" id="send_to" type="number" />
         <button class="btn btn-success btn-sm" onclick="return ajax_send_test_msg();">'.__('Send', 'notifier-for-phone').'</button><span class="loading-reminder-message"></span>
      </div>
      <div style="margin-top:5px;">
         <span style="color:red;"><i>'.__('*check tab log for response', 'notifier-for-phone').'</i></span>
      </div>

      <script type="text/javascript">jQuery(function(){
         jQuery("#send_to").attr("type","text");
         jQuery("#send_to").intlTelInput({
            preferredCountries: ["'.$default_country.'"],p
         });
         jQuery("#send_to").css("padding-right","40px");
         jQuery("#send_to").intlTelInput({
            preferredCountries: ["'.$default_country.'"],
         });
         });
      </script>
      ';
   }

   
   $popup = nwa_popup_license();
   
   return $html.$script.$popup;
}

function nwa_popup_license(){
   $view = 
   '<div class="modal fade" id="tooltiplicense" tabindex="-1" role="dialog" aria-labelledby="tooltiplicenseLabel" aria-hidden="true">
     <div class="modal-dialog modal-lg" role="document">
       <div class="modal-content">
         <div class="modal-header">
           <h5 class="modal-title" id="tooltiplicenseLabel">'.__('Where is your license? Here!', 'notifier-for-phone').'</h5>
           <button type="button" class="close" data-dismiss="modal" aria-label="Close">
             <span aria-hidden="true">&times;</span>
           </button>
         </div>
         <div class="modal-body">
           <img src="'.plugins_url('notifier-for-phone/public/img/how-to-get-license.jpg').'" style="display: block; margin-left: auto; margin-right: auto; width: 50%;">
         </div>
         <div class="modal-body">
           <a type="button" class="btn btn-success" data-dismiss="modal" onclick="window.open(\'https://app.qweasd123.com\',\'_blank\')">'.__('Click here to get your license', 'notifier-for-phone').'</a>
         </div>
       </div>
     </div>
   </div>
   
   <div class="modal fade" id="getcrmtoken" tabindex="-1" role="dialog" aria-labelledby="getcrmtokenLabel" aria-hidden="true">
     <div class="modal-dialog modal-lg" role="document">
       <div class="modal-content">
         <div class="modal-header">
           <h5 class="modal-title" id="getcrmtokenLabel">'.__('Where is your token? Here!', 'notifier-for-phone').'</h5>
           <button type="button" class="close" data-dismiss="modal" aria-label="Close">
             <span aria-hidden="true">&times;</span>
           </button>
         </div>
         <div class="modal-body">
           <img src="'.plugins_url('notifier-for-phone/public/img/how-to-get-crm-token.jpg').'" style="display: block; margin-left: auto; margin-right: auto; width: 50%;">
         </div>
       </div>
     </div>
   </div>
   ';

   return $view;
}