<?php

function nwa_activate_license_callback($post){ 
   $domain = $_SERVER['SERVER_NAME'];
   $license_key = $license_key = (isset( $_POST['my-license'])) ? sanitize_text_field ($_POST['my-license']) : '' ; 

   $api_params = array(
      'plm_action' => 'plm_activate',
      'secret_key' => MY_VERIFICATION_KEY,
      'license_key' => $license_key,
      'registered_domain' => $domain,
      'version' => 'premium'
   ); 

   $response = wp_remote_get( add_query_arg( $api_params, MY_HOST_SERVER ), array( 
      'timeout' => 20, 
      'sslverify' => false 
   )); 

   $license_data = json_decode( wp_remote_retrieve_body( $response ) );
   if ( is_wp_error( $response ) || empty($license_data->product_name) ){
      update_option('errorlicense', 1);
      $license_data = array( 
         'result' => 'error',
         'message' => "Unexpected Error! The query returned with an error."
      ); 
      
   }else{
      update_option('errorlicense', 1);
      // echo "<pre>".print_r($response,1)."</pre>asd";
      if ($license_data->result=='error' || empty($license_data->product_name)) {
         update_option('errorlicense', 1);
      }else{
         update_option('errorlicense', 0);
         update_option(PLUGIN_PREFIX."_license",'active');
         update_option(PLUGIN_PREFIX."_product_name", $license_data->product_name);
         update_option(PLUGIN_PREFIX."_license_number", $post['my-license']);

         if (strpos(strtolower($license_data->product_name), 'android')) {
            update_option(PLUGIN_PREFIX.'_license_type','android');
         }else if(strpos(strtolower($license_data->product_name), 'multivendor')){
            update_option(PLUGIN_PREFIX.'_license_type','multivendor');
         }else if(strpos(strtolower($license_data->product_name), 'crm')){
            if (strpos(strtolower($license_data->product_name), 'eco') && !empty($license_data->api_key)) {
               $ip = trim($license_data->ip);
               $api_key = trim($license_data->api_key);

               update_option(PLUGIN_PREFIX.'_ip', $ip);
               update_option(PLUGIN_PREFIX.'_api_key', $api_key);
            }
            update_option(PLUGIN_PREFIX.'_license_type','crm');
         }else if(strpos(strtolower($license_data->product_name), 'multics')){
            update_option(PLUGIN_PREFIX.'_license_type','multics');
            $ip = trim($license_data->ip);
            $api_key = trim($license_data->api_key);

            update_option(PLUGIN_PREFIX.'_ip', $ip);
            update_option(PLUGIN_PREFIX.'_api_key', $api_key);
         }else {
            update_option(PLUGIN_PREFIX.'_license_type', '');
            $ip = trim($license_data->ip);
            $api_key = trim($license_data->api_key);

            update_option(PLUGIN_PREFIX.'_ip', $ip);
            update_option(PLUGIN_PREFIX.'_api_key', $api_key);
         }
      }
      nwa_writelog("license : ".$license_data->message."");
   }

   return $license_data->message; 
}

if (get_option('errorlicense') == 1) {
   add_action( 'admin_notices', 'nwa_notif_errorlicense' );
}

function nwa_notif_errorlicense() {
	$class = 'notice notice-error';
   $message = PLUGIN_NAME.__( '\'s Notice : License invalid. please contact CS at <a href="https://www.messenger.com/t/woowhatsapp" target="_blank">here</a> !');

	printf( '<div style="margin-left: 0px;" class="%1$s"><p>%2$s</p></div>', esc_attr( $class ),  $message  ); 
}

if (get_option(PLUGIN_PREFIX.'_license_type') == 'crm' && empty(get_option(PLUGIN_PREFIX.'_token_crm'))) {
   add_action( 'admin_notices', 'nwa_error_no_default_crm_token' );
}

function nwa_error_no_default_crm_token() {
	$class = 'notice notice-error';
   $message = PLUGIN_NAME.__( '\'s Notice : Please set your default Token! Before using ').PLUGIN_NAME;

	printf( '<div style="margin-left: 0px;" class="%1$s"><p>%2$s</p></div>', esc_attr( $class ),  $message  ); 
}

function nwa_cek_license_expired(){
	$license=get_option(PLUGIN_PREFIX.'_license_number');
	$url=CEK_EXPIRED.$license;
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL,$url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$expired_date = curl_exec($ch);
	$err = curl_error($ch);
	curl_close ($ch);

	return $expired_date;
}

function nwa_deactivate_license_callback(){ 
   $license_key = ( isset( $_POST['my-license'] ) ) ? sanitize_text_field ( $_POST['my-license']) : '' ; 
   $domain = $_SERVER['SERVER_NAME']; 
   $api_params = array( 
      'plm_action' => 'plm_deactivate', 
      'secret_key' => MY_VERIFICATION_KEY, 
      'license_key' => $license_key, 
      'registered_domain' => $domain, 
   ); 

   $response = wp_remote_get( add_query_arg( $api_params, MY_HOST_SERVER ), array( 
      'timeout' => 20, 
      'sslverify' => false 
   ));

   if ( is_wp_error( $response ) ){ 
      $license_data = array( 
         'result' => 'error', 
         'message' => "Unexpected Error! The query returned with an error." 
      ); 
   }else{ 
      $license_data = json_decode( wp_remote_retrieve_body( $response ) ); 
      update_option(PLUGIN_PREFIX."_license",'deactive');
      update_option(PLUGIN_PREFIX."_license_number",'');
      update_option(PLUGIN_PREFIX."_api_key",'');
      update_option(PLUGIN_PREFIX.'_token_crm', '');
   } 
   //echo 'deactivate_license_callback'; 

   return $license_data->message;
}

function nwa_save_ip_key(){
   $ip = $_POST['ip'];
   $key = $_POST['key'];

   update_option(PLUGIN_PREFIX.'_ip', $ip);
   update_option(PLUGIN_PREFIX.'_api_key', $key);
   
   die();
}

function nwa_save_token(){
   $token = $_POST['token'];
   
   update_option(PLUGIN_PREFIX.'_token_crm', $token);
}

function nwa_send_test_message(){
   $no_wa = trim($_POST['no_wa']);
   $main = new Main();
   $site_url = get_site_url();
   if (empty($site_url)) {
       $site_url = '';
   }
   $gmt                = get_option('gmt_offset');
   $site_url = str_replace('https://', '', $site_url);
   $site_url = str_replace('http://', '', $site_url);
   $site_url = str_replace('www.', '', $site_url);
   $site_url_arr = explode('/', $site_url);
   
   if (is_array($site_url_arr)) {
       $site_url = $site_url_arr[0];
   }
   $date = gmdate("d-m-Y H:i:s", time() + 3600*($gmt+date("I")));

   $data_api['key']          = get_option(PLUGIN_PREFIX.'_api_key', $key);;
   $data_api['text']         = "$date test send message from $site_url";
   $data_api['type']         = "TEST SEND MESSAGE";
   $data_api['domain']       = $site_url;
   $data_api['order_id']     = strtotime('d-m-Y H:i:s');
   $data_api['no_wa_tujuan'] = $no_wa;
   $data_api['country_code'] = get_option(PLUGIN_PREFIX.'_default_country_code_huruf');
   $data_api['license']      = get_option(PLUGIN_PREFIX.'_license_number');

   $return['data_api'] = $data_api;

   $data = $main->send_message($return);
   $main->writelog($data['log']);

}