<?php

function nwa_send_message_wanotif($data, $order_id){
	$apikey  = get_option(PLUGIN_PREFIX.'_provider_tokenwanotif');
	$image   = $data['file'];
	$phone   = $data['no_wa_tujuan'];
	$message = $data['text'];
	$url     = 'https://api.wanotif.id/v1/send';

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_HEADER, 0);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($curl, CURLOPT_TIMEOUT,30);
	curl_setopt($curl, CURLOPT_POST, 1);
	curl_setopt($curl, CURLOPT_POSTFIELDS, array(
		'Apikey'    => $apikey,
		'Phone'     => $phone,
		'Message'   => $message,
	));
	$response = curl_exec($curl);
	curl_close($curl); 

    nwa_writelog("Send message via Wanotif");
	if($image != ''){
		nwa_send_image_wanotif($image, $phone);
	}
}

function nwa_send_image_wanotif($image, $phone){
    $apikey = get_option(PLUGIN_PREFIX.'_provider_tokenwanotif');
    $body = $image;
    $caption = '';
    $filename = "image.jpg";
    $url = 'https://api.wanotif.id/v1/sendfile';

    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HEADER, 0);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($curl, CURLOPT_TIMEOUT,30);
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt($curl, CURLOPT_POSTFIELDS, array(
        'Apikey'    => $apikey,
        'Phone'     => $phone,
        'Body'      => $body,
        'Caption'   => $caption,
        'Filename'  => $filename
    ));
    $response = curl_exec($curl);
    curl_close($curl); 

}

function nwa_send_message_wa_blas($data, $order_id){
    $text = $data['text'];
    $image = $data['file'];
    $phone = $data['no_wa_tujuan'];
    $token = get_option(PLUGIN_PREFIX.'_provider_tokenwa_blas');

    $curl = curl_init();
    $data = [
        'phone' => $phone,
        'message' => $text,
    ];

    curl_setopt($curl, CURLOPT_HTTPHEADER,
        array(
            "Authorization: $token",
        )
    );
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($curl, CURLOPT_URL, "https://console.wablas.com/api/send-message");
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
    $result = curl_exec($curl);
    curl_close($curl);

    $result = json_decode($result);

    if (!empty($image)) {
        nwa_send_image_wa_blas($phone, $token, $image);
    }
    nwa_writelog('Send message via Wablas');
}

function nwa_send_image_wa_blas($phone, $token, $image){
    $token = get_option(PLUGIN_PREFIX.'_provider_tokenwa_blas');

    $curl = curl_init();
    $data = [
        'phone' => $phone,
        'image' => $image,
    ];

    curl_setopt($curl, CURLOPT_HTTPHEADER,
        array(
            "Authorization: $token",
        )
    );
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($curl, CURLOPT_URL, "https://console.wablas.com/api/send-image");
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
    $result = curl_exec($curl);

    curl_close($curl);
}

function nwa_send_message_chatapi($data,$order_id){
    $url     = get_option(PLUGIN_PREFIX.'_url_providerchat_api');
    $token   = get_option(PLUGIN_PREFIX.'_provider_tokenchat_api');
    $url     = $url."message?token=".$token;
    $url     = trim($url);
    $data2   = array("phone"=>$data['no_wa_tujuan'],"body"=>$data['text']);
    $payload = json_encode($data2);
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Token:'.$token,
        'Content-Length: ' . strlen($payload))
    );
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    
    nwa_writelog('Send message via Chat-Api');

    if (!empty($data['file'])) {
        nwa_send_image_chatapi($data, $order_id);
    }
}

function nwa_send_image_chatapi($data, $order_id){
    $url = get_option(PLUGIN_PREFIX.'_url_providerchat_api');
    $token = get_option(PLUGIN_PREFIX.'_provider_tokenchat_api');
    $url = $url."sendFile?token=".$token;
    $url = trim($url);
    $data2 = array("phone"=>$data['no_wa_tujuan'],"body"=>$data['file'],"filename"=>"pics.jpg");
    $payload = json_encode($data2);
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Token:'.$token,
        'Content-Length: ' . strlen($payload))
    );
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    
}

function nwa_send_message_apiwha($data, $order_id){
    $text = $data['text'];
    $image = trim($data['file']);
    $nomer = trim($data['no_wa_tujuan']);
    $api = trim(get_option(PLUGIN_PREFIX.'_provider_tokenapiwha'));
    $text = urlencode($text);

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://panel.apiwha.com/send_message.php?apikey=$api&number=$nomer&text=$text",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    nwa_writelog("Send message via Apiwha");

    if (!empty($image)) {
        nwa_send_image_apiwha($nomer, $image);
    }
}

function nwa_send_image_apiwha($nomer, $image){
    $api = trim(get_option(PLUGIN_PREFIX.'_provider_tokenapiwha'));

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://panel.apiwha.com/send_message.php?apikey=$api&number=$nomer&text=$image",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);
}

function nwa_send_message_wassenger($data, $order_id){
    $text = $data['text'];
    $image_url = $data['file'];
    $phone = "+".$data['no_wa_tujuan'];
    $token = get_option(PLUGIN_PREFIX.'_provider_tokenwassenger');

    $text = preg_replace("/[\n\r\t]/","\\n",$text); 
    
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://api.wassenger.com/v1/messages",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "{\"phone\":\"$phone\",\"message\":\"$text\"}",
        CURLOPT_HTTPHEADER => array(
            "content-type: application/json",
            "token: $token"
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    
    nwa_writelog('Send message via Wassenger');

    if ($image != '') {
        nwa_upload_image_wassenger($image_url, $phone);
    }
}

function nwa_upload_image_wassenger($image_url, $phone){
    $token = get_option(PLUGIN_PREFIX.'_provider_tokenwassenger');

    $curl = curl_init();
    curl_setopt_array($curl, array(
    CURLOPT_URL => "https://api.wassenger.com/v1/files?reference=file1",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => "{\"url\":\"$image_url\"}",
    CURLOPT_HTTPHEADER => array(
            "content-type: application/json",
            "token: $token"
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    $response = json_decode($response);
    
    if($response->status == '409'){
        $image_id = $response->meta->file;
    }else {
        $image_id = $response[0]->id;
    }

    nwa_send_image_wassenger($image_id. $phone);
}

function nwa_send_image_wassenger($image_id, $phone){
    $token = get_option(PLUGIN_PREFIX.'_provider_tokenwassenger');

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://api.wassenger.com/v1/messages",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "{\"phone\":\"$phone\",\"media\":{\"file\":\"$image_id\"}}",
        CURLOPT_HTTPHEADER => array(
            "content-type: application/json",
            "token: $token"
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);
}

function nwa_send_message_waboxapp($data, $order_id){
    $token =get_option(PLUGIN_PREFIX.'_provider_tokenwaboxapp');
    $sender = get_option(PLUGIN_PREFIX."_provider_devicewaboxapp");
    $to = $data['no_wa_tujuan'];
    $unique = $order_id.rand(0,9);
    $text = urlencode($data['text']);
    $image = $data['file'];

    $ch = curl_init(); 
    curl_setopt($ch, CURLOPT_URL, "https://www.waboxapp.com/api/send/chat"); 
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); 
    curl_setopt($ch, CURLOPT_POST, 1); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, "token=$token&uid=$sender&to=$to&custom_uid=$unique&text=$text"); 
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); 
    curl_setopt($ch, CURLOPT_MAXREDIRS, 5); 
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 20); 
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 25); 
    
    $response = curl_exec($ch); 
    $info = curl_getinfo($ch); 
    curl_close ($ch);

    nwa_writelog("Send message via Waboxapp");
    
    nwa_send_image_waboxapp($to, $unique, $image);
}

function nwa_send_image_waboxapp($to, $unique, $image){
    $unique = $unique.rand(0,9);
    $token = get_option(PLUGIN_PREFIX.'_provider_tokenwaboxapp');
    $sender = get_option(PLUGIN_PREFIX."_provider_devicewaboxapp");

    $ch = curl_init(); 
    curl_setopt($ch, CURLOPT_URL, "https://www.waboxapp.com/api/send/image"); 
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); 
    curl_setopt($ch, CURLOPT_POST, 1); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, "token=$token&uid=$sender&to=$to&custom_uid=$unique&url=$image"); 
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); 
    curl_setopt($ch, CURLOPT_MAXREDIRS, 5); 
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 20); 
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 25); 
    
    $response = curl_exec($ch); 
    $info = curl_getinfo($ch); 
    curl_close ($ch);
}