<?php

nwa_hook_wpajax('file_upload');
nwa_hook_wpajax('add_custom_status');
nwa_hook_wpajax('save_custom_status');
nwa_hook_wpajax('onoff_custom_status');
nwa_hook_wpajax('delete_custom_status');
nwa_hook_wpajax('update_custom_status');

add_action('woocommerce_order_status_changed', 'nwa_sendapi_custom_status', 10, 1);

function nwa_sendapi_custom_status($order_id){
    $order = wc_get_order( $order_id );
    $orderstatus = $order->get_status();
    $tipe = str_replace('-','_',$orderstatus);
    $json = get_option(PLUGIN_PREFIX.'_custom_status_data');
    $array = json_decode($json, 1);

    $data = array('cancelled', 'refunded', 'failed', 'completed', 'on_hold', 'processing', 'pending');
    
    if (!empty($array)) {
        foreach ($array as $key => $value) {
            if(!in_array($tipe, $data)){
                if ($tipe == $value['slug']) {
                    $result = $value['slug'];
                    nwa_send_custom_status( $order_id, $result, $key);
                    nwa_send_seller_custom_status( $order_id, $result);
                }
            }
        }
    }
    
}

function nwa_send_custom_status( $order_id, $type = '', $id ){
    $type = 'custom_status'.$type;
    if (get_option(PLUGIN_PREFIX.'_license_type') == 'multivendor') {
        nwa_sendapi($order_id, $type);
    }else {
        $main_customer = new MainCustomer();
        $data = $main_customer->get_setting($order_id, $id);
        $main = new Main();
        if ($data['flow'] == true){
            $data_order = $main->get_data_order($order_id, $type);
            if ($data_order['data_api']['file'] != '') {
                $main->send_image($data_order);
            }
            $data = $main->send_message($data_order);
        }
        $main->writelog($data['log']);
    }
}

function nwa_send_seller_custom_status( $order_id, $type = ''){
    if (get_option(PLUGIN_PREFIX.'_license_type') == 'multivendor') {
        nwa_sendapi($order_id, $type);
    }else {
        $judul   = str_replace('_', ' ', $type);
        $judul   = ucwords($judul);
        $main        = new Main();
        $main_seller = new MainSeller();
        $data        = $main_seller->get_setting($order_id, $type);
        if ($data['flow'] == true){
            $data = $data['wa_number'];
            foreach ($data as $key => $no_wa) {
                $data_order  = $main->get_data_order($order_id, 'seller_notification'.$type);
                $data_order['no_wa_tujuan'] = $no_wa;
                
                $data = $main->send_message($data_order);
                
                if ($data_order['data_api']['file'] != '') {
                    $main->send_image($data_order);
                }

                $main->writelog($data['log']);
            }
        }
    }
}