<?php

$afterCheckout = new \nwa\Modules\AfterCheckout();

add_action( 'woocommerce_checkout_order_processed', [ $afterCheckout, 'set_delay_after_checkout' ], 10, 1 );
add_action( 'nwa_after_checkout',  [ $afterCheckout, 'send_after_checkout' ], 10, 1 );

nwa_hook_wpajax('file_upload');
nwa_hook_wpajax('save_after_checkout');
nwa_hook_wpajax('onoff_after_checkout');

function nwa_save_after_checkout(){
    $afterCheckout = new \nwa\Modules\AfterCheckout();
    $data = $afterCheckout->validation($_POST);
    echo $afterCheckout->save($data);

    die();
}

function nwa_after_checkout_checkbox_page( $checkout ){
    $afterCheckout = new \nwa\Modules\AfterCheckout();
    $view_checkbox = $afterCheckout->checkbox_checkoutpage( $checkout );

    return $view_checkbox;
}

add_action('woocommerce_after_checkout_billing_form', 'nwa_after_checkout_checkbox_page');//munculin checkbox send WA di checkout page

function nwa_send_customer_after_checkout($order_id, $type = 'after_checkout'){
    if (get_post_meta($order_id, 'nwa_after_checkout', true) == '') {
        update_post_meta($order_id, 'nwa_after_checkout', 'sent');
        $main_customer = new MainCustomer();
        $data = $main_customer->get_setting($order_id, $type = 'after_checkout');
        $main = new Main();
        if ($data['flow'] == true){
            $data_order = $main->get_data_order($order_id, $type);
            $data = $main->send_message($data_order);
            if ($data_order['data_api']['file'] != '') {
                $main->send_image($data_order);
            }
        }
        $main->writelog($data['log']);
    }
}
// add_action('woocommerce_thankyou', 'nwa_send_customer_after_checkout', 10, 1);
// add_action('woocommerce_new_order', 'nwa_send_customer_after_checkout', 10, 1);
// add_action('woocommerce_checkout_order_processed', 'nwa_send_customer_after_checkout', 10, 1);

function nwa_send_seller_after_checkout($order_id, $type = 'after_checkout'){
    if (get_post_meta($order_id, 'nwa_after_checkout_seller', true) == '') {
        update_post_meta($order_id, 'nwa_after_checkout_seller', 'sent');
        $main_seller = new MainSeller();
        $data = $main_seller->get_setting($order_id, $type = 'after_checkout');
        $main = new Main();
        if ($data['flow'] == true){
            $data = $data['wa_number'];
            foreach ($data as $key => $no_wa) {
                $data_order  = $main->get_data_order($order_id, 'seller_notification'.$type);
                $data_order['no_wa_tujuan'] = $no_wa;
                $data = $main->send_message($data_order);
                if ($data_order['data_api']['file'] != '') {
                    $main->send_image($data_order);
                }
    
                $main->writelog($data['log']);
            }
        }     
    }
}
// add_action('woocommerce_thankyou', 'nwa_send_seller_after_checkout', 10, 1);
// add_action('woocommerce_new_order', 'nwa_send_seller_after_checkout', 10, 1);
// add_action('woocommerce_checkout_order_processed', 'nwa_send_seller_after_checkout', 10, 1);

// add_filter('is_protected_meta', 'nwa_remove_metadata', 10, 2);
add_action('woocommerce_checkout_update_order_meta', 'nwa_cw_checkout_order_meta');