<?php
namespace nwa\Modules;

class AfterCheckout{

	public function set_delay_after_checkout( $order_id ) {
		if ( ! $order_id )
			return;
			
            if (get_option(PLUGIN_PREFIX.'_toggle_after_checkout') == 'checked'){
                // Allow code execution only once 
                $order = wc_get_order( $order_id );
                $order_status  = $order->get_status();
				$this->set_cron_action_scheduler( $order_id, 'after_checkout' );
                // if ( $order_status == 'on-hold' ){
				// }
            }else {
                nwa_writelog('After Checkout toggle is OFF');
            }
	}

	/**
	 * set cron action scheduler
	 * @param int $order_id
	 * @param int $kirim_wa_ke
	 * @return void
	 */
	public function set_cron_action_scheduler( $order_id, $type = 'after_checkout' ) {
        $timezone = get_option('timezone_string');
		if (empty($timezone) or $timezone == '') {
			// $timezone="Asia/Jakarta";
		} else {
			date_default_timezone_set($timezone);
		}

		$post = get_post( $order_id );
		if ( is_a( $post,'WP_Post' ) && $post->post_type === 'shop_order' ) :
			
			$add_seconds = 10;
			$timestamp = strtotime( 'now +'. $add_seconds .' seconds' );
			$hook = 'nwa_after_checkout';
			$args = [
				[
					'order_id' 		=> $order_id,
					'timestamp'	=> $timestamp,
					'type_order'	=> 'after_checkout',
				]
			];
			$group = 'nwa_scheduler';
	
			if ( false === as_next_scheduled_action( $hook, $args, $group ) ) :
				as_schedule_single_action( $timestamp, $hook, $args, $group );
			endif;
		endif;

	}

	/**
	 * send delay order
	 * hooked via action nwa_delay_order_scheduler, priority 10
	 * @param array $data
	 * @return void
	 */
	public function send_after_checkout( $data ) {
        $order_id = $data['order_id'];
        $type = $data['type_order'];
		
        nwa_send_customer_after_checkout($order_id, $type);
        nwa_send_seller_after_checkout($order_id, $type);

	}

	public function validation($p){
		$post['gambar']     = $p['image'];
	    $post['checkbox']   = $p['checkboximage'];
	    $post['pesan']      = $p['pesan_after_checkout'];
	    $post['toggle']     = $p['onoff_after_checkout'];
	    $post['pesan'] = stripslashes($post['pesan']);
		$post['pesan'] = str_replace("\'", "'", $post['pesan']);
		
	    return $post;
	}

	public function save($post){
		extract($post);
		if ( get_option(PLUGIN_PREFIX.'_pesan_after_checkout') !== false ) {
			update_option(PLUGIN_PREFIX.'_pesan_after_checkout', $pesan);
		} else {
		    $deprecated = null;
		    $autoload = 'no';
		    add_option(PLUGIN_PREFIX.'_pesan_after_checkout', $pesan, $deprecated, $autoload );
		}

		if ( $checkbox == 'check' ) {
	        $checked="checked=checked";
	        if ( get_option(PLUGIN_PREFIX.'_check_after_checkout') !== false ) {
	            update_option(PLUGIN_PREFIX.'_check_after_checkout', $checked);
	        }else{
	            add_option(PLUGIN_PREFIX.'_check_after_checkout', $checked);
	        }
	    }else {
	        update_option(PLUGIN_PREFIX.'_check_after_checkout', '');
	    }

	    if ( $gambar!='' ) {
	        if( get_option(PLUGIN_PREFIX.'_image_after_checkout') !== false ){
	            update_option(PLUGIN_PREFIX.'_image_after_checkout', $gambar);
	        }else {
	            add_option(PLUGIN_PREFIX.'_image_after_checkout', $gambar);
	        }
	    }else {
	        update_option(PLUGIN_PREFIX.'_image_after_checkout', '');
	    }

	    $fb = '<br>
	        <div class="alert alert-success" role="alert" >
	        Data Saved.
	    </div>';

		return $fb;
	}

	public function checkbox_checkoutpage( $checkout ) {
		if (get_option(PLUGIN_PREFIX.'_checkbox_wa_notif') == 'checked=checked') {
			echo '<div class="cw_custom_class">';
			$checked = $checkout->get_value( 'custom_checkbox' ) ? $checkout->get_value( 'custom_checkbox' ) : 0;
			if (get_option(PLUGIN_PREFIX."_checkbox_checked_confirmation") == 'checked=checked') {
				$checked = $checkout->get_value( 'custom_checkbox' ) ? $checkout->get_value( 'custom_checkbox' ) : 1;
			}
			
			woocommerce_form_field( 'custom_checkbox', array(
				'type'          => 'checkbox',
				'label'         => __(get_option(PLUGIN_PREFIX.'_checkbox_wa_text')),
				'required'      => false,
			), $checked);
			echo '</div>'; 
		}
	}
}