<?php 

namespace nwa\Modules;

class AbandonedCartFollowup {

	/**
	 * set reminder order after checkout
	 * hooked via action woocommerce_thankyou, priority 10
	 * @param int $order_id
	 * @return void
	 */
	public function set_reminder_abandoned_cart_followup() {
		// nwa_writelog('masuk set reminder followup');
		
		if (get_option(PLUGIN_PREFIX.'_onoff_abandoned_cart_followup') == 'checked'){
			// nwa_writelog('masuk set reminder followup 2');

			// Allow code execution only once 
			$this->set_cron_action_scheduler('abandoned_cart_followup' );
		}else {
			// nwa_writelog('Order Completed Followup toggle is OFF');
		}
	}

	/**
	 * set cron action scheduler
	 * @param int $order_id
	 * @param int $kirim_wa_ke
	 * @return void
	 */
	public function set_cron_action_scheduler($type = 'abandoned_cart_followup' ) {
		// nwa_writelog('masuk set reminder followup 3');
        $timezone = get_option('timezone_string');
		if (empty($timezone) or $timezone == '') {
			// $timezone="Asia/Jakarta";
		} else {
			date_default_timezone_set($timezone);
		}

		$data = nwa_get_abandoned_cart();
		$last_data_count= get_option('last_data_count_abandoned_cart');
		
		if ( $data > $last_data_count ) :
			// nwa_writelog('masuk set reminder followup 4');
			foreach ($data as $key => $value) :
				// nwa_writelog('masuk set reminder followup 5/5');
				if (!empty($value['phone']) && !empty($value['email'])) :
					$id = $value['id'];
					// nwa_writelog('masuk set reminder followup 5');
					// nwa_writelog($id);
					if (get_option('record_abandoned_followup'.$id) != 2 || empty(get_option('record_abandoned_followup'.$id))) {
						// nwa_writelog('masuk set reminder followup 5/6');
						update_option('record_abandoned_followup'.$id, 1);
					}

					$message_record = get_option('record_abandoned_followup'.$id);
					
					// check sudah pernah dikirim followup atau belum
					if ( $message_record == 1) :
						// nwa_writelog('masuk set reminder followup 6');
						
						$time_limit = get_option(PLUGIN_PREFIX."_time_limit_abandoned_cart");
						if (empty($time_limit)) :
							$time_limit = 2;
						endif;
						
						$time_type = get_option(PLUGIN_PREFIX."_time_type_abandoned_cart");
						if (empty($time_type)) :
							$time_type = "day";
						endif;
						
						$add_minutes = 0;
						
						switch ( $time_type ) {
							case 'day':
								$add_minutes = $time_limit*24*60;
							break;
						
							case 'hour':
								$add_minutes = $time_limit*60;
							break;
						}

						// perlu tambah ngecek jika time dibawha hari ini maka disetting dikirim dari hari ini
						
						$today = date('Y-m-d H:i:s');
						$time  = $value['time'];
						if ($today > $time) {
							// $time = 'now';
						}
						
						// testing 2 menit scheduler nya jalan
						// $time = 'now';
						// $add_minutes = 2;

						$timestamp = strtotime( $time.' +'. $add_minutes .' minutes' );


						$hook = 'nwa_abandoned_cart_followup_hook';
						$args = [
									[
										'data' 		=> $value,
										'timestamp'	=> $timestamp,
										'type_order'	=> 'abandoned_cart',
									]
								];
						$group = 'nwa_scheduler';
							
						if ( false === as_next_scheduled_action( $hook, $args, $group ) ) :
							// nwa_writelog('masuk set reminder followup 7');
							// nwa_writelog('Abandoned Cart message for id #'.$id.' will be send at ' . date('d-m-Y H:i', $timestamp) . ' Please make sure to access the website around that time, the message will be cancel if the user decide to finish the order before scheduled time,');
							update_option('record_abandoned_followup'.$id, 2);

							as_schedule_single_action( $timestamp, $hook, $args, $group );
						endif;
					endif;
				endif;
			endforeach;
		endif;

	}

	/**
	 * send reminder order
	 * hooked via action nwa_reminder_order_scheduler, priority 10
	 * @param array $data
	 * @return void
	 */
	public function send_abandoned_cart_followup( $data ) {
		$data_order = $data['data'];
		$id 		= $data_order['id'];
		$status 	= $data_order['type'];
		if ($status != 2 ) {
			$timezone = get_option('timezone_string');
			$date = new \DateTime('NOW', new \DateTimeZone($timezone));
			$date->setTimezone(new \DateTimeZone($timezone));
			$last_sent_date = $date->format('Y-m-d H:i');
	
			update_post_meta('000000'.$id, 'nwa_ac_last_send', $last_sent_date);

			nwa_form_abandoned_cart($data_order, 'abandoned_cart');
		} 

	}

}