<?php

/**
 * Rule.
 * 
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('FGF_Rule')) {

	/**
	 * Class.
	 * 
	 * @since 1.0.0
	 */
	class FGF_Rule extends FGF_Post {

		/**
		 * Post Type.
		 * 
		 * @since 1.0.0
		 * @var string
		 */
		protected $post_type = FGF_Register_Post_Types::RULES_POSTTYPE;

		/**
		 * Post Status.
		 * 
		 * @since 1.0.0
		 * @var string
		 */
		protected $post_status = 'fgf_active';

		/**
		 * Name.
		 * 
		 * @since 1.0.0
		 * @var string
		 */
		protected $name;

		/**
		 * Description.
		 * 
		 * @since 1.0.0
		 * @var string
		 */
		protected $description;

		/**
		 * Created Date.
		 * 
		 * @since 1.0.0
		 * @var string
		 */
		protected $created_date;

		/**
		 * Modified Date.
		 * 
		 * @since 1.0.0
		 * @var string
		 */
		protected $modified_date;

		/**
		 * Meta data keys.
		 * 
		 * @since 1.0.0
		 * @var array
		 */
		protected $meta_data_keys = array(
			'fgf_rule_type' => '1',
			'fgf_gift_type' => '1',
			'fgf_gift_products' => array(),
			'fgf_gift_categories' => array(),
			'fgf_bogo_gift_type' => '1',
			'fgf_buy_product_type' => '1',
			'fgf_buy_product' => array(),
			'fgf_buy_categories' => array(),
			'fgf_buy_category_type' => '1',
			'fgf_get_product_type' => '1',
			'fgf_get_products' => array(),
			'fgf_get_categories' => array(),
			'fgf_buy_quantity_type' => '1',
			'fgf_buy_product_count' => '',
			'fgf_get_product_count' => '',
			'fgf_bogo_gift_repeat' => '',
			'fgf_bogo_gift_repeat_mode' => '1',
			'fgf_bogo_gift_repeat_limit' => '',
			'fgf_apply_coupon' => array(),
			'fgf_coupon_gift_products' => array(),
			'fgf_coupon_gift_products_qty' => '1',
			'fgf_rule_valid_from_date' => '',
			'fgf_rule_valid_to_date' => '',
			'fgf_rule_week_days_validation' => array(),
			'fgf_automatic_product_qty' => '',
			'fgf_rule_gifts_count_per_order' => '',
			'fgf_rule_usage_count' => '',
			'fgf_rule_restriction_count' => '',
			'fgf_rule_allowed_user_type' => '1',
			'fgf_rule_allowed_user_count' => '1',
			'fgf_rule_allowed_user_usage_count' => array(),
			'fgf_rule_user_purchased_order_count_type' => 1,
			'fgf_rule_user_purchased_order_min_count' => 1,
			'fgf_rule_user_purchased_order_max_count' => 1,
			'fgf_exclude_category_subtotal_discount_amount' => '',
			'fgf_condition_type' => '',
			'fgf_total_type' => '',
			'fgf_cart_categories' => array(),
			'fgf_consider_cart_subcategories_total' => 1,
			'fgf_cart_subtotal_min_value' => '',
			'fgf_cart_subtotal_max_value' => '',
			'fgf_quantity_min_value' => '',
			'fgf_quantity_max_value' => '',
			'fgf_product_count_min_value' => '',
			'fgf_product_count_max_value' => '',
			'fgf_show_notice' => '',
			'fgf_notice' => '',
			'fgf_user_filter_type' => '',
			'fgf_include_users' => array(),
			'fgf_exclude_users' => array(),
			'fgf_include_user_roles' => array(),
			'fgf_exclude_user_roles' => array(),
			'fgf_product_filter_type' => '',
			'fgf_include_products' => array(),
			'fgf_include_product_count' => '',
			'fgf_exclude_products' => array(),
			'fgf_applicable_products_type' => '',
			'fgf_applicable_categories_type' => '',
			'fgf_include_categories' => array(),
			'fgf_include_category_product_count' => '1',
			'fgf_exclude_categories' => array()
		);

		/**
		 * Compatibility meta data keys.
		 * 
		 * @since 9.4.0
		 * @var array
		 */
		protected $compatibility_meta_data_keys = array(
			'fgf_cart_brands' => array(),
			'fgf_applicable_brands_type' => '1',
			'fgf_include_brands' => array(),
			'fgf_exclude_brands' => array(),
			'fgf_brand_product_count' => ''
		);

		/**
		 * Prepare extra post data.
		 * 
		 * @since 1.0.0
		 */
		protected function load_extra_postdata() {
			$this->name = $this->post->post_title;
			$this->description = $this->post->post_content;
			$this->created_date = $this->post->post_date_gmt;
			$this->modified_date = $this->post->post_modified_gmt;
		}

		/**
		 * Get the formatted created datetime.
		 * 
		 * @since 1.0.0
		 * @return string
		 */
		public function get_formatted_created_date() {
			return FGF_Date_Time::get_wp_format_datetime($this->get_created_date());
		}

		/**
		 * Get the formatted modified datetime.
		 * 
		 * @since 1.0.0
		 * @return string
		 */
		public function get_formatted_modified_date() {
			return FGF_Date_Time::get_wp_format_datetime($this->get_modified_date());
		}

		/**
		 * Get the rule mode.
		 * 
		 * @since 1.0.0
		 * @return string
		 */
		public function get_rule_mode() {
			switch ($this->get_rule_type()) {
				case '2':
					$mode = 'automatic';
					break;
				case '3':
					$mode = 'bogo';
					break;
				case '4':
					$mode = 'coupon';
					break;
				case '5':
					$mode = 'manual_bogo';
					break;
				default:
					$mode = 'manual';
					break;
			}

			return $mode;
		}

		/**
		 * Is exclude category subtotal discount amount?
		 * 
		 * @since 9.6.0
		 * @return boolean
		 */
		public function is_exclude_category_subtotal_discount_amount() {
			return '2' == $this->get_exclude_category_subtotal_discount_amount();
		}

		/**
		 * Setters and Getters
		 */

		/**
		 * Set name.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_name( $value) {
			$this->name = $value;
		}

		/**
		 * Set description.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_description( $value) {
			$this->description = $value;
		}

		/**
		 * Set created date.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_created_date( $value) {
			$this->created_date = $value;
		}

		/**
		 * Set modified date.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_modified_date( $value) {
			$this->modified_date = $value;
		}

		/**
		 * Set rule type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_rule_type( $value) {
			$this->set_prop('fgf_rule_type', $value);
		}

		/**
		 * Set gift type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_gift_type( $value) {
			$this->set_prop('fgf_gift_type', $value);
		}

		/**
		 * Set gift products.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_gift_products( $value) {
			$this->set_prop('fgf_gift_products', $value);
		}

		/**
		 * Set gift categories.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_gift_categories( $value) {
			$this->set_prop('fgf_gift_categories', $value);
		}

		/**
		 * Set BOGO gift type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_bogo_gift_type( $value) {
			$this->set_prop('fgf_bogo_gift_type', $value);
		}

		/**
		 * Set buy product type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_buy_product_type( $value) {
			$this->set_prop('fgf_buy_product_type', $value);
		}

		/**
		 * Set buy product.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_buy_product( $value) {
			$this->set_prop('fgf_buy_product', $value);
		}

		/**
		 * Set buy categories.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_buy_categories( $value) {
			$this->set_prop('fgf_buy_categories', $value);
		}

		/**
		 * Set buy category type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_buy_category_type( $value) {
			$this->set_prop('fgf_buy_category_type', $value);
		}

		/**
		 * Set get product type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_get_product_type( $value) {
			$this->set_prop('fgf_get_product_type', $value);
		}

		/**
		 * Set get products.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_get_products( $value) {
			$this->set_prop('fgf_get_products', $value);
		}

		/**
		 * Set get categories.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_get_categories( $value) {
			$this->set_prop('fgf_get_categories', $value);
		}

		/**
		 * Set buy quantity type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_buy_quantity_type( $value) {
			$this->set_prop('fgf_buy_quantity_type', $value);
		}

		/**
		 * Set buy product count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_buy_product_count( $value) {
			$this->set_prop('fgf_buy_product_count', $value);
		}

		/**
		 * Set get product count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_get_product_count( $value) {
			$this->set_prop('fgf_get_product_count', $value);
		}

		/**
		 * Set BOGO gift repeat.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_bogo_gift_repeat( $value) {
			$this->set_prop('fgf_bogo_gift_repeat', $value);
		}

		/**
		 * Set BOGO gift repeat mode.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_bogo_gift_repeat_mode( $value) {
			$this->set_prop('fgf_bogo_gift_repeat_mode', $value);
		}

		/**
		 * Set BOGO gift repeat limit.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_bogo_gift_repeat_limit( $value) {
			$this->set_prop('fgf_bogo_gift_repeat_limit', $value);
		}

		/**
		 * Set apply coupon.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_apply_coupon( $value) {
			$this->set_prop('fgf_apply_coupon', $value);
		}

		/**
		 * Set coupon gift products.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_coupon_gift_products( $value) {
			$this->set_prop('fgf_coupon_gift_products', $value);
		}

		/**
		 * Set coupon gift products quantity.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_coupon_gift_products_qty( $value) {
			$this->set_prop('fgf_coupon_gift_products_qty', $value);
		}

		/**
		 * Set rule valid from date.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_rule_valid_from_date( $value) {
			$this->set_prop('fgf_rule_valid_from_date', $value);
		}

		/**
		 * Set rule valid to date.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_rule_valid_to_date( $value) {
			$this->set_prop('fgf_rule_valid_to_date', $value);
		}

		/**
		 * Set rule week days validation.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_rule_week_days_validation( $value) {
			$this->set_prop('fgf_rule_week_days_validation', $value);
		}

		/**
		 * Set automatic product qty.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_automatic_product_qty( $value) {
			$this->set_prop('fgf_automatic_product_qty', $value);
		}

		/**
		 * Set rule gifts count per order.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_rule_gifts_count_per_order( $value) {
			$this->set_prop('fgf_rule_gifts_count_per_order', $value);
		}

		/**
		 * Set rule restriction count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_rule_restriction_count( $value) {
			$this->set_prop('fgf_rule_restriction_count', $value);
		}

		/**
		 * Set rule usage count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_rule_usage_count( $value) {
			$this->set_prop('fgf_rule_usage_count', $value);
		}

		/**
		 * Set rule allowed user type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_rule_allowed_user_type( $value) {
			$this->set_prop('fgf_rule_allowed_user_type', $value);
		}

		/**
		 * Set rule allowed user count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_rule_allowed_user_count( $value) {
			$this->set_prop('fgf_rule_allowed_user_count', $value);
		}

		/**
		 * Set rule allowed user usage count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_rule_allowed_user_usage_count( $value) {
			$this->set_prop('fgf_rule_allowed_user_usage_count', $value);
		}

		/**
		 * Set rule user purchased order count type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_rule_user_purchased_order_count_type( $value) {
			$this->set_prop('fgf_rule_user_purchased_order_count_type', $value);
		}

		/**
		 * Set rule user purchased order minimum count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_rule_user_purchased_order_min_count( $value) {
			$this->set_prop('fgf_rule_user_purchased_order_min_count', $value);
		}

		/**
		 * Set rule user purchased order maximum count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_rule_user_purchased_order_max_count( $value) {
			$this->set_prop('fgf_rule_user_purchased_order_max_count', $value);
		}

		/**
		 * Set exclude subtotal discount amount.
		 * 
		 * @since 9.6.0
		 * @param int $value
		 */
		public function set_exclude_category_subtotal_discount_amount( $value) {
			$this->set_prop('fgf_exclude_category_subtotal_discount_amount', $value);
		}

		/**
		 * Set condition type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_condition_type( $value) {
			$this->set_prop('fgf_condition_type', $value);
		}

		/**
		 * Set total type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_total_type( $value) {
			$this->set_prop('fgf_total_type', $value);
		}

		/**
		 * Set cart categories.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_cart_categories( $value) {
			$this->set_prop('fgf_cart_categories', $value);
		}

		/**
		 * Set consider cart subcategories total.
		 * 
		 * @since 1.0.0
		 * @param float $value
		 */
		public function set_consider_cart_subcategories_total( $value) {
			$this->set_prop('fgf_consider_cart_subcategories_total', $value);
		}

		/**
		 * Set cart subtotal minimum value.
		 * 
		 * @since 1.0.0
		 * @param float $value
		 */
		public function set_cart_subtotal_minimum_value( $value) {
			$this->set_prop('fgf_cart_subtotal_min_value', $value);
		}

		/**
		 * Set cart subtotal maximum value.
		 * 
		 * @since 1.0.0
		 * @param float $value
		 */
		public function set_cart_subtotal_maximum_value( $value) {
			$this->set_prop('fgf_cart_subtotal_max_value', $value);
		}

		/**
		 * Set quantity minimum value.
		 * 
		 * @since 1.0.0
		 * @param float $value
		 */
		public function set_quantity_minimum_value( $value) {
			$this->set_prop('fgf_quantity_min_value', $value);
		}

		/**
		 * Set quantity maximum value.
		 * 
		 * @since 1.0.0
		 * @param float $value
		 */
		public function set_quantity_maximum_value( $value) {
			$this->set_prop('fgf_quantity_min_value', $value);
		}

		/**
		 * Set product count minimum value.
		 * 
		 * @since 1.0.0
		 * @param float $value
		 */
		public function set_product_count_min_value( $value) {
			$this->set_prop('fgf_product_count_min_value', $value);
		}

		/**
		 * Set product count maximum value.
		 * 
		 * @since 1.0.0
		 * @param float $value
		 */
		public function set_product_count_max_value( $value) {
			$this->set_prop('fgf_product_count_max_value', $value);
		}

		/**
		 * Set show notice.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_show_notice( $value) {
			$this->set_prop('fgf_show_notice', $value);
		}

		/**
		 * Set notice.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_notice( $value) {
			$this->set_prop('fgf_notice', $value);
		}

		/**
		 * Set user filter type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_user_filter_type( $value) {
			$this->set_prop('fgf_user_filter_type', $value);
		}

		/**
		 * Set include users.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_include_users( $value) {
			$this->set_prop('fgf_include_users', $value);
		}

		/**
		 * Set exclude users.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_exclude_users( $value) {
			$this->set_prop('fgf_exclude_users', $value);
		}

		/**
		 * Set include user roles
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_include_user_roles( $value) {
			$this->set_prop('fgf_gift_type', $value);
			$this->fgf_include_user_roles = $value;
		}

		/**
		 * Set exclude user roles.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_exclude_user_roles( $value) {
			$this->set_prop('fgf_exclude_user_roles', $value);
		}

		/**
		 * Set product filter type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_product_filter_type( $value) {
			$this->set_prop('fgf_product_filter_type', $value);
		}

		/**
		 * Set include products.
		 */
		public function set_include_products( $value) {
			$this->set_prop('fgf_include_products', $value);
		}

		/**
		 * Set exclude products.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_exclude_products( $value) {
			$this->set_prop('fgf_exclude_products', $value);
		}

		/**
		 * Set applicable products type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_applicable_products_type( $value) {
			$this->set_prop('fgf_applicable_products_type', $value);
		}

		/**
		 * Set include product count.
		 */
		public function set_include_product_count( $value) {
			$this->set_prop('fgf_include_product_count', $value);
		}

		/**
		 * Set applicable categories type.
		 * 
		 * @since 1.0.0
		 * @param string $value
		 */
		public function set_applicable_categories_type( $value) {
			$this->set_prop('fgf_applicable_categories_type', $value);
		}

		/**
		 * Set include categories.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_include_categories( $value) {
			$this->set_prop('fgf_include_categories', $value);
		}

		/**
		 * Set include categories product count.
		 * 
		 * @since 1.0.0
		 * @param int $value
		 */
		public function set_include_category_product_count( $value) {
			$this->set_prop('fgf_include_category_product_count', $value);
		}

		/**
		 * Set exclude categories.
		 * 
		 * @since 1.0.0
		 * @param array $value
		 */
		public function set_exclude_categories( $value) {
			$this->set_prop('fgf_exclude_categories', $value);
		}

		/**
		 * Get the name.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_name() {
			return $this->name;
		}

		/**
		 * Get the description.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_description() {
			return $this->description;
		}

		/**
		 * Get the created date.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_created_date() {
			return $this->created_date;
		}

		/**
		 * Get the modified date.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_modified_date() {
			return $this->modified_date;
		}

		/**
		 * Get the rule type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_rule_type() {
			return $this->get_prop('fgf_rule_type');
		}

		/**
		 * Get the gift type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_gift_type() {
			return $this->get_prop('fgf_gift_type');
		}

		/**
		 * Get the gift products.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_gift_products() {
			return $this->get_prop('fgf_gift_products');
		}

		/**
		 * Get the gift categories.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_gift_categories() {
			return $this->get_prop('fgf_gift_categories');
		}

		/**
		 * Get the BOGO gift type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_bogo_gift_type() {
			return $this->get_prop('fgf_bogo_gift_type');
		}

		/**
		 * Get the buy product type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_buy_product_type() {
			return $this->get_prop('fgf_buy_product_type');
		}

		/**
		 * Get the buy product.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_buy_product() {
			return $this->get_prop('fgf_buy_product');
		}

		/**
		 * Get the buy categories.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_buy_categories() {
			return $this->get_prop('fgf_buy_categories');
		}

		/**
		 * Get the buy category type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_buy_category_type() {
			return $this->get_prop('fgf_buy_category_type');
		}

		/**
		 * Get the product type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_product_type() {
			return $this->get_prop('fgf_get_product_type');
		}

		/**
		 * Get the products.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_products() {
			return $this->get_prop('fgf_get_products');
		}

		/**
		 * Get the categories.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_categories() {
			return $this->get_prop('fgf_get_categories');
		}

		/**
		 * Get the buy quantity type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_buy_quantity_type() {
			return $this->get_prop('fgf_buy_quantity_type');
		}

		/**
		 * Get the buy product count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_buy_product_count() {
			return $this->get_prop('fgf_buy_product_count');
		}

		/**
		 * Get the product count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_product_count() {
			return $this->get_prop('fgf_get_product_count');
		}

		/**
		 * Get the BOGO gift repeat.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_bogo_gift_repeat() {
			return $this->get_prop('fgf_bogo_gift_repeat');
		}

		/**
		 * Get the BOGO gift repeat mode.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_bogo_gift_repeat_mode() {
			return $this->get_prop('fgf_bogo_gift_repeat_mode');
		}

		/**
		 * Get the BOGO gift repeat limit.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_bogo_gift_repeat_limit() {
			return $this->get_prop('fgf_bogo_gift_repeat_limit');
		}

		/**
		 * Get the apply coupon.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_apply_coupon() {
			return $this->get_prop('fgf_apply_coupon');
		}

		/**
		 * Get the coupon gift products.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_coupon_gift_products() {
			return $this->get_prop('fgf_coupon_gift_products');
		}

		/**
		 * Get the coupon gift products quantity.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_coupon_gift_products_qty() {
			return $this->get_prop('fgf_coupon_gift_products_qty');
		}

		/**
		 * Get the rule valid from date.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_rule_valid_from_date() {
			return $this->get_prop('fgf_rule_valid_from_date');
		}

		/**
		 * Get the rule valid to date.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_rule_valid_to_date() {
			return $this->get_prop('fgf_rule_valid_to_date');
		}

		/**
		 * Get the rule week days validation.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_rule_week_days_validation() {
			return $this->get_prop('fgf_rule_week_days_validation');
		}

		/**
		 * Get the automatic product qty.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_automatic_product_qty() {
			return $this->get_prop('fgf_automatic_product_qty');
		}

		/**
		 * Get the rule gifts count per order.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_rule_gifts_count_per_order() {
			return $this->get_prop('fgf_rule_gifts_count_per_order');
		}

		/**
		 * Get the rule restriction count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_rule_restriction_count() {
			return $this->get_prop('fgf_rule_restriction_count');
		}

		/**
		 * Get the rule usage count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_rule_usage_count() {
			return $this->get_prop('fgf_rule_usage_count');
		}

		/**
		 * Get the rule allowed user type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_rule_allowed_user_type() {
			return $this->get_prop('fgf_rule_allowed_user_type');
		}

		/**
		 * Get the rule allowed user count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_rule_allowed_user_count() {
			return $this->get_prop('fgf_rule_allowed_user_count');
		}

		/**
		 * Get the rule allowed user usage count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_rule_allowed_user_usage_count() {
			return $this->get_prop('fgf_rule_allowed_user_usage_count');
		}

		/**
		 * Get the rule user purchased order count type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_rule_user_purchased_order_count_type() {
			return $this->get_prop('fgf_rule_user_purchased_order_count_type');
		}

		/**
		 * Get the rule user purchased order minimum count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_rule_user_purchased_order_min_count() {
			return $this->get_prop('fgf_rule_user_purchased_order_min_count');
		}

		/**
		 * Get the rule user purchased order maximum count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_rule_user_purchased_order_max_count() {
			return $this->get_prop('fgf_rule_user_purchased_order_max_count');
		}

		/**
		 * Get the exclude subtotal discount amount.
		 * 
		 * @since 9.6.0
		 * @return int
		 */
		public function get_exclude_category_subtotal_discount_amount() {
			return $this->get_prop('fgf_exclude_category_subtotal_discount_amount');
		}

		/**
		 * Get the condition type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_condition_type() {
			return $this->get_prop('fgf_condition_type');
		}

		/**
		 * Get the total type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 * */
		public function get_total_type() {
			return $this->get_prop('fgf_total_type');
		}

		/**
		 * Get the cart categories.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_cart_categories() {
			return $this->get_prop('fgf_cart_categories');
		}

		/**
		 * Get the consider cart subcategories total.
		 * 
		 * @since 1.0.0
		 * @retrun boolean
		 */
		public function get_consider_cart_subcategories_total() {
			return '2' == $this->get_prop('fgf_consider_cart_subcategories_total');
		}

		/**
		 * Get the cart subtotal minimum value.
		 * 
		 * @since 1.0.0
		 * @retrun float
		 */
		public function get_cart_subtotal_minimum_value() {
			return $this->get_prop('fgf_cart_subtotal_min_value');
		}

		/**
		 * Get the cart subtotal maximum value.
		 * 
		 * @since 1.0.0
		 * @retrun float
		 */
		public function get_cart_subtotal_maximum_value() {
			return $this->get_prop('fgf_cart_subtotal_max_value');
		}

		/**
		 * Get the quantity minimum value.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_quantity_minimum_value() {
			return $this->get_prop('fgf_quantity_min_value');
		}

		/**
		 * Get the quantity maximum value.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_quantity_maximum_value() {
			return $this->get_prop('fgf_quantity_max_value');
		}

		/**
		 * Get the product count minimum value.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_product_count_min_value() {
			return $this->get_prop('fgf_product_count_min_value');
		}

		/**
		 * Get the product count maximum value.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_product_count_max_value() {
			return $this->get_prop('fgf_product_count_max_value');
		}

		/**
		 * Get the show notice.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_show_notice() {
			return $this->get_prop('fgf_show_notice');
		}

		/**
		 * Get the notice.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_notice() {
			return $this->get_prop('fgf_notice');
		}

		/**
		 * Get the user filter type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_user_filter_type() {
			return $this->get_prop('fgf_user_filter_type');
		}

		/**
		 * Get the include users.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_include_users() {
			return $this->get_prop('fgf_include_users');
		}

		/**
		 * Get the exclude users.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_exclude_users() {
			return $this->get_prop('fgf_exclude_users');
		}

		/**
		 * Get the include user roles.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_include_user_roles() {
			return $this->get_prop('fgf_include_user_roles');
		}

		/**
		 * Get the exclude user roles.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_exclude_user_roles() {
			return $this->get_prop('fgf_exclude_user_roles');
		}

		/**
		 * Get the product filter type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_product_filter_type() {
			return $this->get_prop('fgf_product_filter_type');
		}

		/**
		 * Get the include products.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_include_products() {
			return $this->get_prop('fgf_include_products');
		}

		/**
		 * Get the products count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_include_product_count() {
			return $this->get_prop('fgf_include_product_count');
		}

		/**
		 * Get the exclude products.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_exclude_products() {
			return $this->get_prop('fgf_exclude_products');
		}

		/**
		 * Get the applicable products type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_applicable_products_type() {
			return $this->get_prop('fgf_applicable_products_type');
		}

		/**
		 * Get the applicable categories type.
		 * 
		 * @since 1.0.0
		 * @retrun string
		 */
		public function get_applicable_categories_type() {
			return $this->get_prop('fgf_applicable_categories_type');
		}

		/**
		 * Get the include categories.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_include_categories() {
			return $this->get_prop('fgf_include_categories');
		}

		/**
		 * Get the include categories product count.
		 * 
		 * @since 1.0.0
		 * @retrun int
		 */
		public function get_include_category_product_count() {
			return $this->get_prop('fgf_include_category_product_count');
		}

		/**
		 * Get the exclude categories.
		 * 
		 * @since 1.0.0
		 * @retrun array
		 */
		public function get_exclude_categories() {
			return $this->get_prop('fgf_exclude_categories');
		}

	}

}
