<?php

/**
 * Polylang Compatibility.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'FGF_Polylang_Compatibility' ) ) {

	/**
	 * Class.
	 */
	class FGF_Polylang_Compatibility extends FGF_Compatibility {

		/**
		 * Class Constructor.
		 */
		public function __construct() {
			$this->id = 'polylang' ;

			parent::__construct() ;
		}

		/**
		 * Is plugin enabled?.
		 * 
		 *  @return bool
		 * */
		public function is_plugin_enabled() {
			return class_exists( 'Polylang' ) ;
		}

		/**
		 * Action
		 */
		public function actions() {
			// Check if the product id is valid.
			add_filter( 'fgf_is_valid_product', array( $this, 'valid_product' ), 10, 2 ) ;
		}

		/**
		 * Check if the product id is valid for current language?.
		 * 
		 * @return bool
		 */
		public function valid_product( $bool, $product_id ) {
			if ( pll_get_post_language( $product_id ) == pll_current_language() ) {
				return $bool ;
			}

			return false ;
		}

	}

}
