<?php
/**
 *  Rule restrictions data.
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div id="fgf_rule_data_restrictions" class="fgf-rule-options-wrapper">
	<table class="form-table">
		<tbody>

			<?php
			/**
			 * This hook is used to do extra action before rule restrictions settings.
			 * 
			 * @since 1.0
			 */
			do_action('fgf_before_rule_restrictions_settings', $rule_data);
			?>

			<tr>
				<th scope='row'>
					<label><?php esc_html_e('Rule Validity', 'free-gifts-for-woocommerce'); ?>
						<?php fgf_wc_help_tip(__('If left empty, the rule will be valid on all days.', 'free-gifts-for-woocommerce')); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped. ?>
					</label>
				</th>
				<td>
					<?php esc_html_e('From', 'free-gifts-for-woocommerce'); ?>
					<?php
					$rule_valid_from_date_args = array(
						'name' => 'fgf_rule[fgf_rule_valid_from_date]',
						'value' => $rule_data['fgf_rule_valid_from_date'],
						'wp_zone' => false,
						'placeholder' => FGF_Date_Time::get_wp_date_format(),
					);
					fgf_get_datepicker_html($rule_valid_from_date_args);
					?>
				</td>
				<td>
					<?php esc_html_e('To', 'free-gifts-for-woocommerce'); ?>
					<?php
					$rule_valid_to_date_args = array(
						'name' => 'fgf_rule[fgf_rule_valid_to_date]',
						'value' => $rule_data['fgf_rule_valid_to_date'],
						'wp_zone' => false,
						'placeholder' => FGF_Date_Time::get_wp_date_format(),
					);
					fgf_get_datepicker_html($rule_valid_to_date_args);
					?>
				</td>
			</tr>

			<tr>
				<th scope='row'>
					<label><?php esc_html_e('Week Day(s) Restrictions', 'free-gifts-for-woocommerce'); ?>
						<?php fgf_wc_help_tip(__('The rule will be valid for the selected Days. If left empty, the rule will be valid for all days of the week.', 'free-gifts-for-woocommerce')); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped. ?>
					</label>
				</th>

				<td>
					<select class="fgf-rule-week-days-validation fgf_select2" multiple="multiple" name="fgf_rule[fgf_rule_week_days_validation][]">
						<?php foreach (fgf_get_rule_week_days_options() as $week_days_id => $week_days_name) : ?>
							<option value="<?php echo esc_attr($week_days_id); ?>" <?php echo in_array($week_days_id, $rule_data['fgf_rule_week_days_validation']) ? 'selected="selected"' : ''; ?>><?php echo esc_html($week_days_name); ?></option>
						<?php endforeach; ?>
					</select>
				</td>
			</tr>

			<?php if ('2' == get_option('fgf_settings_gifts_count_per_order_type', '2')) : ?>
				<tr>
					<th scope='row'>
						<label><?php esc_html_e('Maximum Gifts in an Order from this Rule', 'free-gifts-for-woocommerce'); ?>
							<?php fgf_wc_help_tip(__('If left empty / when the rule value is more the Global Restriction, the Global Restriction will apply.', 'free-gifts-for-woocommerce')); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped. ?>
						</label>
					</th>
					<td>
						<input type="number" class="fgf_rule_type fgf_manual_rule_type" name="fgf_rule[fgf_rule_gifts_count_per_order]" min="1" value="<?php echo esc_attr($rule_data['fgf_rule_gifts_count_per_order']); ?>"/>
					</td>				
				</tr>
			<?php endif; ?>

			<tr>
				<th scope='row'>
					<label><?php esc_html_e('Order Restrictions', 'free-gifts-for-woocommerce'); ?>
						<?php fgf_wc_help_tip(__('If left empty, the rule will be valid for unlimited orders', 'free-gifts-for-woocommerce')); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped. ?>
					</label>
				</th>
				<td>
					<input type="number" name="fgf_rule[fgf_rule_restriction_count]" min="1" value="<?php echo esc_attr($rule_data['fgf_rule_restriction_count']); ?>"/>
				</td>
				<?php if ($rule_data['fgf_rule_restriction_count']) : ?>
					<td>    
						<?php
						$remaining_count = max(floatval($rule_data['fgf_rule_restriction_count']) - floatval($rule_data['fgf_rule_usage_count']), 0);
						/* translators: %s: number of orders and rule usage count */
						echo wp_kses_post(sprintf(__('Orders (%1$s used %2$d remaining)', 'free-gifts-for-woocommerce'), floatval($rule_data['fgf_rule_usage_count']), $remaining_count));
						?>
						<input type="button" class="fgf_reset_rule_usage_count button-primary" data-rule-id="<?php echo esc_attr($rule_data['id']); ?>" value="<?php esc_attr_e('Reset used count', 'free-gifts-for-woocommerce'); ?>"/>
					</td>
				<?php endif; ?>
			</tr>

			<tr>
				<th scope='row'>
					<label><?php esc_html_e('Order Restriction per User', 'free-gifts-for-woocommerce'); ?><span class="required">*</span>
						<?php fgf_wc_help_tip(__('When set to Enable, registered users can be restricted to receive free gift(s) from this rule for a fixed number of times.', 'free-gifts-for-woocommerce')); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped. ?>
					</label>
				</th>
				<td>
					<select class="fgf_rule_allowed_user_type" name="fgf_rule[fgf_rule_allowed_user_type]">
						<option value="1" <?php selected($rule_data['fgf_rule_allowed_user_type'], '1'); ?>><?php esc_html_e('Disable', 'free-gifts-for-woocommerce'); ?></option>
						<option value="2" <?php selected($rule_data['fgf_rule_allowed_user_type'], '2'); ?>><?php esc_html_e('Enable - For Registered Users Only', 'free-gifts-for-woocommerce'); ?></option>
					</select>
				</td>
			</tr>

			<tr>
				<th scope='row'>
					<label><?php esc_html_e('Number of Order(s) per User', 'free-gifts-for-woocommerce'); ?>
						<?php fgf_wc_help_tip(__('The number of order(s) for which each registered users can receive gift product(s) from this rule.', 'free-gifts-for-woocommerce')); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped. ?>
					</label>
				</th>
				<td>
					<input type="number" class="fgf_rule_allowed_user_count fgf-rule-user-count-field" name="fgf_rule[fgf_rule_allowed_user_count]" min="0" value="<?php echo esc_attr($rule_data['fgf_rule_allowed_user_count']); ?>"/>
				</td>				
			</tr>

			<tr>
				<th scope='row'>
					<label><?php esc_html_e("Award Gift based on User's Purchase History", 'free-gifts-for-woocommerce'); ?><span class="required">*</span></label>
				</th>
				<td>
					<select class='fgf_rule_user_purchased_order_count_type fgf-rule-user-count-field' name='fgf_rule[fgf_rule_user_purchased_order_count_type]'>
						<option value='1' <?php selected($rule_data['fgf_rule_user_purchased_order_count_type'], '1'); ?>><?php esc_html_e('Disable', 'free-gifts-for-woocommerce'); ?></option>
						<option value='2' <?php selected($rule_data['fgf_rule_user_purchased_order_count_type'], '2'); ?>><?php esc_html_e('No Purchase History Available Case Only', 'free-gifts-for-woocommerce'); ?></option>
						<option value='3' <?php selected($rule_data['fgf_rule_user_purchased_order_count_type'], '3'); ?>><?php esc_html_e('Specific Number of Orders', 'free-gifts-for-woocommerce'); ?></option>
					</select>
				</td>
			</tr>

			<tr>
				<th scope='row'>
					<label><?php esc_html_e('Previously Purchased Order Count', 'free-gifts-for-woocommerce'); ?><span class="required">*</span></label>
				</th>
				<td>
					<?php esc_html_e('Min', 'free-gifts-for-woocommerce'); ?>
					<input type='number' name='fgf_rule[fgf_rule_user_purchased_order_min_count]' class='fgf_rule_user_purchased_order_min_count fgf-rule-user-count-field' min='1' value='<?php echo esc_attr($rule_data['fgf_rule_user_purchased_order_min_count']); ?>'/>
				</td>
				<td>
					<?php esc_html_e('Max', 'free-gifts-for-woocommerce'); ?>
					<input type='number' name='fgf_rule[fgf_rule_user_purchased_order_max_count]' class='fgf_rule_user_purchased_order_max_count fgf-rule-user-count-field' min='1' value='<?php echo esc_attr($rule_data['fgf_rule_user_purchased_order_max_count']); ?>'/>
				</td>
			</tr>

			<?php
			/**
			 * This hook is used to do extra action after rule restrictions settings.
			 * 
			 * @since 1.0
			 */
			do_action('fgf_after_rule_restrictions_settings', $rule_data);
			?>
		</tbody>
	</table>
</div>
<?php
