<?php
/**
 *  Rule notices data.
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div id="fgf_rule_data_notices" class="fgf-rule-options-wrapper">
	<div class="fgf-options-group">
		<table class="form-table">
			<tbody>

				<?php
				/**
				 * This hook is used to do extra action before rule notices settings.
				 * 
				 * @since 1.0
				 */
				do_action('fgf_before_rule_notices_settings', $rule_data);
				?>

				<tr>
					<th scope='row'>
						<label><?php esc_html_e('Display Free Gift Eligibility Notice in Cart for this Rule', 'free-gifts-for-woocommerce'); ?>
							<?php fgf_wc_help_tip(__('When set to "Show", a notice will be displayed to user in cart and checkout if they are not eligible for receiving free gifts from this rule.', 'free-gifts-for-woocommerce')); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped. ?>
						</label>
					</th>
					<td>
						<select name="fgf_rule[fgf_show_notice]" class="fgf_rule_show_notice">
							<option value="1" <?php selected($rule_data['fgf_show_notice'], '1'); ?>><?php esc_html_e('Hide', 'free-gifts-for-woocommerce'); ?></option>
							<option value="2" <?php selected($rule_data['fgf_show_notice'], '2'); ?>><?php esc_html_e('Show', 'free-gifts-for-woocommerce'); ?></option>
						</select>
					</td>
				</tr>

				<tr>
					<th scope='row'>
						<label><?php esc_html_e('Free Gifts Eligibility Notice', 'free-gifts-for-woocommerce'); ?></label>
					</th>
					<td>
						<textarea name="fgf_rule[fgf_notice]" cols="20" rows="5" class="fgf_rule_notice"><?php echo wp_kses_post($rule_data['fgf_notice']); ?></textarea>
					</td>
				</tr>

				<?php
				/**
				 * This hook is used to do extra action after rule notices settings.
				 * 
				 * @since 1.0
				 */
				do_action('fgf_after_rule_notices_settings', $rule_data);
				?>

			</tbody>
		</table>
	</div>
	<div class="fgf-options-group">
		<h3><?php esc_html_e('Shortcodes', 'free-gifts-for-woocommerce'); ?></h3>
		<table class="fgf-shortcode-table">
			<?php
			$shortcode_details = fgf_get_rule_notice_shortcode_details();
			if (fgf_check_is_array($shortcode_details)) :
				foreach ($shortcode_details as $short_detail) :
					?>
					<tr>
						<th><?php echo esc_html($short_detail['shortcode']); ?></th>
						<td><?php echo esc_html($short_detail['desc']); ?></td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</table>
	</div>
</div>
<?php
