/* global fgf_rule_params, ajaxurl */

jQuery(function ($) {
	'use strict';

	var FGF_Admin = {
		init: function ( ) {
			this.trigger_on_page_load();
			// rules tab
			$(document).on('change', '.fgf_rule_types', this.toggle_rule_type);
			$(document).on('change', '.fgf_gift_type', this.toggle_gift_type);
			$(document).on('change', '.fgf_bogo_gift_type', this.toggle_bogo_gift_type);
			$(document).on('change', '.fgf_buy_product_type', this.toggle_buy_product_type);
			$(document).on('change', '.fgf_get_product_type', this.toggle_get_product_type);
			$(document).on('change', '.fgf_bogo_gift_repeat', this.toggle_bogo_gift_repeat);
			$(document).on('change', '.fgf_bogo_gift_repeat_mode', this.toggle_bogo_gift_repeat_mode);
			$(document).on('change', '.fgf_rule_show_notice', this.toggle_notice);
			$(document).on('change', '.fgf_user_filter_type', this.toggle_user_filter_type);
			$(document).on('change', '.fgf_product_filter_type', this.toggle_product_filter_type);
			$(document).on('change', '.fgf_applicable_products_type', this.toggle_applicable_products_type);
			$(document).on('change', '.fgf_applicable_categories_type', this.toggle_applicable_categories_type);
			$(document).on('click', '.fgf_reset_rule_usage_count', this.reset_rule_usage_count);
			$(document).on('change', '.fgf-rule-total-type', this.toggle_rule_total_type);
			$(document).on('change', '.fgf_rule_allowed_user_type', this.toggle_rule_allowed_user_type);
			$(document).on('change', '.fgf_rule_user_purchased_order_count_type', this.toggle_rule_user_purchased_order_count_type);

			//Tabbed rule panel.
			$(document).on('fgf-init-tabbed-panels', this.tabbed_rule_panels).trigger('fgf-init-tabbed-panels');

		}, trigger_on_page_load: function ( ) {
			// rules tab
			this.rule_type('.fgf_rule_types');
			this.notice('.fgf_rule_show_notice');
			this.user_filter_type('.fgf_user_filter_type');
			this.product_filter_type('.fgf_product_filter_type');
			this.rule_total_type('.fgf-rule-total-type');
			this.rule_allowed_user_type('.fgf_rule_allowed_user_type');
			this.sortable_default_fields();

		}, toggle_rule_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.rule_type($this);
		}, toggle_gift_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.gift_type($this);
		}, toggle_bogo_gift_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.bogo_gift_type($this);
		}, toggle_buy_product_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.buy_product_type($this);
		}, toggle_get_product_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.get_product_type($this);
		}, toggle_bogo_gift_repeat: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);

			FGF_Admin.bogo_gift_repeat($this);
		}, toggle_bogo_gift_repeat_mode: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);

			FGF_Admin.bogo_gift_repeat_mode($this);
		}, toggle_notice: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);

			FGF_Admin.notice($this);
		}, toggle_user_filter_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.user_filter_type($this);
		}, toggle_product_filter_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.product_filter_type($this);
		}, toggle_applicable_products_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.applicable_products_type($this);
		}, toggle_applicable_categories_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);
			FGF_Admin.applicable_categories_type($this);
		}, toggle_rule_total_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);

			FGF_Admin.rule_total_type($this);
		}, toggle_rule_allowed_user_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);

			FGF_Admin.rule_allowed_user_type($this);
		}, toggle_rule_user_purchased_order_count_type: function (event) {
			event.preventDefault( );
			var $this = $(event.currentTarget);

			FGF_Admin.rule_user_purchased_order_count_type($this);
		}, rule_type: function ($this) {
			$('.fgf-rule-data-tabs').find('.notices_tab').show();
			$('.fgf_rule_type').closest('tr').hide();

			switch ($($this).val()) {
				case '1':
					$('.fgf_gift_products').data('exclude-global-variable', 'no');
					$('.fgf_manual_rule_type').closest('tr').show();
					FGF_Admin.gift_type('.fgf_gift_type');
					break;
				case '2':
					$('.fgf_gift_products').data('exclude-global-variable', 'yes');
					$('.fgf_gift_products').closest('tr').show();
					$('.fgf_automatic_rule_type').closest('tr').show();
					break;
				case '3':
					$('.fgf_get_products').data('exclude-global-variable', 'yes');
					$('.fgf_bogo_rule_type').closest('tr').show();
					$('.fgf_automatic_bogo_rule_type').closest('tr').show();
					FGF_Admin.buy_product_type('.fgf_buy_product_type');
					FGF_Admin.bogo_gift_type('.fgf_bogo_gift_type');
					FGF_Admin.bogo_gift_repeat('.fgf_bogo_gift_repeat');
					break;
				case '4':
					$('.fgf-rule-data-tabs').find('.notices_tab').hide();
					$('.fgf_coupon_rule_type').closest('tr').show();
					break;
				case '5':
					$('.fgf_get_products').data('exclude-global-variable', 'no');
					$('.fgf_bogo_rule_type').closest('tr').show();
					$('.fgf_manual_bogo_rule_type').closest('tr').show();
					FGF_Admin.buy_product_type('.fgf_buy_product_type');
					FGF_Admin.get_product_type('.fgf_get_product_type');
					FGF_Admin.bogo_gift_repeat('.fgf_bogo_gift_repeat');

					break;
			}

		}, gift_type: function ($this) {
			if ($($this).val() === '1') {
				$('.fgf_gift_products').closest('tr').show();
				$('.fgf_gift_categories').closest('tr').hide();
			} else {
				$('.fgf_gift_products').closest('tr').hide();
				$('.fgf_gift_categories').closest('tr').show();
			}
		}, buy_product_type: function ($this) {
			if ($($this).val() === '1') {
				$('.fgf_buy_product').closest('tr').show();
				$('.fgf_buy_categories').closest('tr').hide();
			} else {
				$('.fgf_buy_product').closest('tr').hide();
				$('.fgf_buy_categories').closest('tr').show();
			}

			FGF_Admin.buy_category_type();
		}, get_product_type: function ($this) {
			if ($($this).val() === '1') {
				$('.fgf_get_products').closest('tr').show();
				$('.fgf_get_categories').closest('tr').hide();
			} else {
				$('.fgf_get_products').closest('tr').hide();
				$('.fgf_get_categories').closest('tr').show();
			}
		}, bogo_gift_repeat: function ($this) {
			if ($($this).is(":checked")) {
				$('.fgf_bogo_gift_repeat_field').closest('tr').show();
				FGF_Admin.bogo_gift_repeat_mode('.fgf_bogo_gift_repeat_mode');
			} else {
				$('.fgf_bogo_gift_repeat_field').closest('tr').hide();
			}
		}, bogo_gift_repeat_mode: function ($this) {
			if ($($this).val() === '1') {
				$('.fgf_bogo_gift_repeat_limit').closest('tr').hide();
			} else {
				$('.fgf_bogo_gift_repeat_limit').closest('tr').show();
			}
		}, bogo_gift_type: function ($this) {
			if ($($this).val() === '1') {
				$('.fgf_get_products').closest('tr').hide();
			} else {
				$('.fgf_get_products').closest('tr').show();
			}

			FGF_Admin.buy_category_type();
		}, buy_category_type: function (  ) {

			if (('5' === $('.fgf_rule_types').val() || '2' === $('.fgf_bogo_gift_type').val()) && '2' === $('.fgf_buy_product_type').val()) {
				$('.fgf_buy_category_type').closest('tr').show();
			} else {
				$('.fgf_buy_category_type').closest('tr').hide();
			}
		}, notice: function ($this) {
			if ($($this).val() === '2') {
				$('.fgf_rule_notice').closest('tr').show();
			} else {
				$('.fgf_rule_notice').closest('tr').hide();
			}
		}, user_filter_type: function ($this) {
			$('.fgf_user_filter').closest('tr').hide();
			$('.fgf_user_filter-' + $($this).val()).closest('tr').show();

		}, product_filter_type: function ($this) {
			$('.fgf_product_filter').closest('tr').hide();
			switch ($($this).val()) {
				case '2':
					$('.fgf_include_products').closest('tr').show();
					$('.fgf_applicable_products_type').closest('tr').show();
					FGF_Admin.applicable_products_type('.fgf_applicable_products_type');
					break;

				case '3':
					$('.fgf_exclude_products').closest('tr').show();
					break;

				case '5':
					$('.fgf_include_categories').closest('tr').show();
					$('.fgf_applicable_categories_type').closest('tr').show();
					FGF_Admin.applicable_categories_type('.fgf_applicable_categories_type');
					break;

				case '6':
					$('.fgf_exclude_categories').closest('tr').show();
					break;
			}

			$(document).trigger('fgf_product_filter_type_options', [$($this).val()]);

		}, applicable_products_type: function ($this) {
			$('.fgf_include_product_count').closest('tr').hide();
			if ($($this).val() === '4') {
				$('.fgf_include_product_count').closest('tr').show();
			}
		}, applicable_categories_type: function ($this) {
			$('.fgf_include_category_product_count').closest('tr').hide();
			if ($($this).val() === '4') {
				$('.fgf_include_category_product_count').closest('tr').show();
			}
		}, rule_total_type: function ($this) {
			var val = $($this).val();

			$('.fgf-rule-cart-total-type-fields').closest('tr').hide();
			$('.fgf-rule-cart-total-type-' + val).closest('tr').show();

		}, rule_allowed_user_type: function ($this) {

			if ($($this).val() === '2') {
				$('.fgf-rule-user-count-field').closest('tr').show();
				FGF_Admin.rule_user_purchased_order_count_type('.fgf_rule_user_purchased_order_count_type');
			} else {
				$('.fgf-rule-user-count-field').closest('tr').hide();
			}
		}, rule_user_purchased_order_count_type: function ($this) {
			switch ($($this).val()) {
				case '3':
					$('.fgf_rule_user_purchased_order_min_count').closest('tr').show();
					break;
				default:
					$('.fgf_rule_user_purchased_order_min_count').closest('tr').hide();
					break;
			}
		}, sortable_default_fields: function () {
			var listtable = $('table.fgf_rules #the-list').closest('table');

			listtable.sortable({
				items: 'tr',
				handle: '.fgf_post_sort_handle',
				axis: 'y',
				containment: listtable,
				update: function (event, ui) {
					var sort_order = [];

					listtable.find('.fgf_rules_sortable').each(function (e) {
						sort_order.push($(this).val( ));
					});

					$.post(ajaxurl, {
						action: 'fgf_drag_rules_list',
						sort_order: sort_order,
						fgf_security: fgf_rule_params.fgf_rules_drag_nonce
					});
				}
			});
		}, reset_rule_usage_count: function (event) {
			event.preventDefault();
			var $this = $(event.currentTarget);

			FGF_Admin.block($this);

			var data = {
				action: 'fgf_reset_rule_usage_count',
				rule_id: $($this).data('rule-id'),
				fgf_security: fgf_rule_params.fgf_rules_nonce,
			};

			$.post(ajaxurl, data, function (res) {

				if (true === res.success) {
					alert(res.data.msg);
					location.reload(true);
				} else {
					alert(res.data.error);
				}

				FGF_Admin.unblock($this);
			}
			);
		}, tabbed_rule_panels: function ( ) {

			// trigger the clicked link.
			$('.fgf-rule-data-tab-link').on('click', function (event) {
				event.preventDefault();
				var $this = $(event.currentTarget),
						panel_content = $($this).closest('.fgf-rule-data-panel-content');

				$('.fgf-rule-data-tab', panel_content).removeClass('active');
				$($this).parent().addClass('active');

				$('div.fgf-rule-options-wrapper', panel_content).hide();
				$($($this).attr('href')).show();
			});

			// Trigger the first link.
			$('div.fgf-rule-data-panel-content').each(function () {
				$(this).find('.fgf-rule-data-tab').eq(0).find('a').click();
			});
		}, block: function (id) {
			$(id).block({
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.7
				}
			});
		}, unblock: function (id) {
			$(id).unblock();
		},
	};
	FGF_Admin.init( );
});
