/* global fgf_carousel_params */

jQuery(function ($) {
	'use strict';
	try {

		$(document.body).on('fgf-enhanced-carousel', function ( ) {

			var owl_carousels = $('.fgf-owl-carousel-items');
			if (!owl_carousels.length) {
				return;
			}

			owl_carousels.each(function (e) {
				$(this).owlCarousel({
					loop: true,
					margin: parseInt(fgf_carousel_params.item_margin),
					responsiveClass: true,
					nav: ('true' === fgf_carousel_params.nav),
					navText: [fgf_carousel_params.nav_prev_text, fgf_carousel_params.nav_next_text],
					autoplay: ('true' === fgf_carousel_params.auto_play),
					dots: ('true' === fgf_carousel_params.pagination),
					slideBy: fgf_carousel_params.item_per_slide,
					autoplayTimeout: fgf_carousel_params.slide_speed,
					autoplayHoverPause: true,
					responsive: {
						0: {
							items: fgf_carousel_params.mobile_count,
						},
						600: {
							items: fgf_carousel_params.tablet_count,
						},
						1000: {
							items: fgf_carousel_params.desktop_count,
						}
					}
				});
			});
		});

		// Initialize carousel when cart updated.
		$(document.body).on('updated_wc_div', function ( ) {
			$(document.body).trigger('fgf-enhanced-carousel');
		});

		$(document.body).trigger('fgf-enhanced-carousel');

	} catch (err) {
		window.console.log(err);
	}

});
